"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.queryParamsToEsQuery = queryParamsToEsQuery;
exports.transformToUpdateScheme = exports.transformToCreateScheme = exports.transformESSearchToDefendInsights = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformESSearchToDefendInsights = response => {
  return response.hits.hits.filter(hit => hit._source !== undefined).map(hit => {
    var _insightSchema$users$, _insightSchema$users, _insightSchema$replac, _insightSchema$genera, _insightSchema$genera2, _insightSchema$averag;
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    const insightSchema = hit._source;
    const defendInsight = {
      timestamp: insightSchema['@timestamp'],
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      id: hit._id,
      backingIndex: hit._index,
      createdAt: insightSchema.created_at,
      updatedAt: insightSchema.updated_at,
      lastViewedAt: insightSchema.last_viewed_at,
      users: (_insightSchema$users$ = (_insightSchema$users = insightSchema.users) === null || _insightSchema$users === void 0 ? void 0 : _insightSchema$users.map(user => ({
        id: user.id,
        name: user.name
      }))) !== null && _insightSchema$users$ !== void 0 ? _insightSchema$users$ : [],
      namespace: insightSchema.namespace,
      status: insightSchema.status,
      eventsContextCount: insightSchema.events_context_count,
      apiConfig: {
        connectorId: insightSchema.api_config.connector_id,
        actionTypeId: insightSchema.api_config.action_type_id,
        defaultSystemPromptId: insightSchema.api_config.default_system_prompt_id,
        model: insightSchema.api_config.model,
        provider: insightSchema.api_config.provider
      },
      endpointIds: insightSchema.endpoint_ids,
      insightType: insightSchema.insight_type,
      insights: insightSchema.insights.map(insight => {
        var _insight$events;
        return {
          group: insight.group,
          events: (_insight$events = insight.events) === null || _insight$events === void 0 ? void 0 : _insight$events.map(event => ({
            id: event.id,
            endpointId: event.endpoint_id,
            value: event.value
          })),
          remediation: insight.remediation
        };
      }),
      replacements: (_insightSchema$replac = insightSchema.replacements) === null || _insightSchema$replac === void 0 ? void 0 : _insightSchema$replac.reduce((acc, r) => {
        acc[r.uuid] = r.value;
        return acc;
      }, {}),
      generationIntervals: (_insightSchema$genera = (_insightSchema$genera2 = insightSchema.generation_intervals) === null || _insightSchema$genera2 === void 0 ? void 0 : _insightSchema$genera2.map(interval => ({
        date: interval.date,
        durationMs: interval.duration_ms
      }))) !== null && _insightSchema$genera !== void 0 ? _insightSchema$genera : [],
      averageIntervalMs: (_insightSchema$averag = insightSchema.average_interval_ms) !== null && _insightSchema$averag !== void 0 ? _insightSchema$averag : 0,
      failureReason: insightSchema.failure_reason
    };
    return defendInsight;
  });
};
exports.transformESSearchToDefendInsights = transformESSearchToDefendInsights;
const transformToCreateScheme = (createdAt, spaceId, user, {
  endpointIds,
  insightType,
  insights,
  apiConfig,
  eventsContextCount,
  replacements,
  status
}) => {
  return {
    '@timestamp': createdAt,
    created_at: createdAt,
    users: [{
      id: user.profile_uid,
      name: user.username
    }],
    status,
    api_config: {
      action_type_id: apiConfig.actionTypeId,
      connector_id: apiConfig.connectorId,
      default_system_prompt_id: apiConfig.defaultSystemPromptId,
      model: apiConfig.model,
      provider: apiConfig.provider
    },
    events_context_count: eventsContextCount,
    endpoint_ids: endpointIds,
    insight_type: insightType,
    insights: insights === null || insights === void 0 ? void 0 : insights.map(insight => {
      var _insight$events2;
      return {
        group: insight.group,
        events: (_insight$events2 = insight.events) === null || _insight$events2 === void 0 ? void 0 : _insight$events2.map(event => ({
          id: event.id,
          endpoint_id: event.endpointId,
          value: event.value
        })),
        remediation: insight.remediation
      };
    }),
    updated_at: createdAt,
    last_viewed_at: createdAt,
    replacements: replacements ? Object.keys(replacements).map(key => ({
      uuid: key,
      value: replacements[key]
    })) : undefined,
    namespace: spaceId
  };
};
exports.transformToCreateScheme = transformToCreateScheme;
const transformToUpdateScheme = (updatedAt, {
  eventsContextCount,
  apiConfig,
  insights,
  failureReason,
  generationIntervals,
  id,
  replacements,
  lastViewedAt,
  status
}) => {
  const averageIntervalMsObj = generationIntervals && generationIntervals.length > 0 ? {
    average_interval_ms: Math.trunc(generationIntervals.reduce((acc, interval) => acc + interval.durationMs, 0) / generationIntervals.length),
    generation_intervals: generationIntervals.map(interval => ({
      date: interval.date,
      duration_ms: interval.durationMs
    }))
  } : {};
  return {
    events_context_count: eventsContextCount,
    ...(apiConfig ? {
      api_config: {
        action_type_id: apiConfig.actionTypeId,
        connector_id: apiConfig.connectorId,
        default_system_prompt_id: apiConfig.defaultSystemPromptId,
        model: apiConfig.model,
        provider: apiConfig.provider
      }
    } : {}),
    ...(insights ? {
      insights: insights.map(insight => {
        var _insight$events3;
        return {
          group: insight.group,
          events: (_insight$events3 = insight.events) === null || _insight$events3 === void 0 ? void 0 : _insight$events3.map(event => ({
            id: event.id,
            endpoint_id: event.endpointId,
            value: event.value
          })),
          remediation: insight.remediation
        };
      })
    } : {}),
    failure_reason: failureReason,
    id,
    replacements: replacements ? Object.keys(replacements).map(key => ({
      uuid: key,
      value: replacements[key]
    })) : undefined,
    ...(status ? {
      status
    } : {}),
    // only update updated_at time if this is not an update to last_viewed_at
    ...(lastViewedAt ? {
      last_viewed_at: lastViewedAt
    } : {
      updated_at: updatedAt
    }),
    ...averageIntervalMsObj
  };
};
exports.transformToUpdateScheme = transformToUpdateScheme;
const validParams = new Set(['ids', 'endpoint_ids', 'connector_id', 'type', 'status']);
const paramKeyMap = {
  ids: '_id',
  connector_id: 'api_config.connector_id',
  type: 'insight_type'
};
function queryParamsToEsQuery(queryParams) {
  return Object.entries(queryParams).reduce((acc, [k, v]) => {
    if (!validParams.has(k)) {
      return acc;
    }
    const filterKey = (0, _lodash.isArray)(v) ? 'terms' : 'term';
    const paramKey = (0, _lodash.get)(paramKeyMap, k, k);
    const next = {
      [filterKey]: {
        [paramKey]: v
      }
    };
    return [...acc, next];
  }, []);
}