"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformAttackDiscoveryAlertDocumentToApi = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _moment = _interopRequireDefault(require("moment"));
var _fp = require("lodash/fp");
var _field_names = require("../../../../schedules/fields/field_names");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformAttackDiscoveryAlertDocumentToApi = ({
  attackDiscoveryAlertDocument,
  enableFieldRendering,
  id,
  withReplacements
}) => {
  var _attackDiscoveryAlert, _attackDiscoveryAlert2;
  const doc = attackDiscoveryAlertDocument;
  const renderMarkdownField = field => {
    if (field == null) {
      return field;
    }
    if (!enableFieldRendering) {
      return (0, _elasticAssistantCommon.getMarkdownFields)(field); // transforms, for example `{{ user.name james }}` to `james`
    }
    return field;
  };
  const getFieldWithReplacement = ({
    replacementField,
    normalField,
    defaultValue
  }) => {
    if (withReplacements && typeof doc[replacementField] === 'string') {
      return doc[replacementField];
    } else if (typeof doc[normalField] === 'string') {
      return doc[normalField];
    }
    return defaultValue;
  };
  const getFieldWithReplacementThenRender = params => (0, _fp.pipe)(() => getFieldWithReplacement(params), val => renderMarkdownField(val))();
  return {
    alert_ids: (_attackDiscoveryAlert = attackDiscoveryAlertDocument[_field_names.ALERT_ATTACK_DISCOVERY_ALERT_IDS]) !== null && _attackDiscoveryAlert !== void 0 ? _attackDiscoveryAlert : [],
    // required field
    alert_rule_uuid: attackDiscoveryAlertDocument[_ruleDataUtils.ALERT_RULE_UUID],
    alert_start: (0, _moment.default)(attackDiscoveryAlertDocument[_ruleDataUtils.ALERT_START]).isValid() ? (0, _moment.default)(attackDiscoveryAlertDocument[_ruleDataUtils.ALERT_START]).toISOString() : undefined,
    // optional field
    alert_updated_at: (0, _moment.default)(attackDiscoveryAlertDocument[_ruleDataUtils.ALERT_UPDATED_AT]).isValid() ? (0, _moment.default)(attackDiscoveryAlertDocument[_ruleDataUtils.ALERT_UPDATED_AT]).toISOString() : undefined,
    // optional field
    alert_updated_by_user_id: attackDiscoveryAlertDocument[_ruleDataUtils.ALERT_UPDATED_BY_USER_ID],
    alert_updated_by_user_name: attackDiscoveryAlertDocument[_ruleDataUtils.ALERT_UPDATED_BY_USER_NAME],
    alert_workflow_status: attackDiscoveryAlertDocument[_ruleDataUtils.ALERT_WORKFLOW_STATUS],
    alert_workflow_status_updated_at: (0, _moment.default)(attackDiscoveryAlertDocument[_ruleDataUtils.ALERT_WORKFLOW_STATUS_UPDATED_AT]).isValid() ? (0, _moment.default)(attackDiscoveryAlertDocument[_ruleDataUtils.ALERT_WORKFLOW_STATUS_UPDATED_AT]).toISOString() : undefined,
    // optional field
    connector_id: attackDiscoveryAlertDocument[_field_names.ALERT_ATTACK_DISCOVERY_API_CONFIG].connector_id,
    // required field
    connector_name: attackDiscoveryAlertDocument[_field_names.ALERT_ATTACK_DISCOVERY_API_CONFIG].name,
    details_markdown: getFieldWithReplacementThenRender({
      replacementField: _field_names.ALERT_ATTACK_DISCOVERY_DETAILS_MARKDOWN_WITH_REPLACEMENTS,
      normalField: _field_names.ALERT_ATTACK_DISCOVERY_DETAILS_MARKDOWN,
      defaultValue: ''
    }),
    // required field
    entity_summary_markdown: getFieldWithReplacementThenRender({
      replacementField: _field_names.ALERT_ATTACK_DISCOVERY_ENTITY_SUMMARY_MARKDOWN_WITH_REPLACEMENTS,
      normalField: _field_names.ALERT_ATTACK_DISCOVERY_ENTITY_SUMMARY_MARKDOWN,
      defaultValue: undefined
    }),
    generation_uuid: (_attackDiscoveryAlert2 = attackDiscoveryAlertDocument[_ruleDataUtils.ALERT_RULE_EXECUTION_UUID]) !== null && _attackDiscoveryAlert2 !== void 0 ? _attackDiscoveryAlert2 : '',
    // required field
    id,
    // required field
    mitre_attack_tactics: Array.isArray(attackDiscoveryAlertDocument[_field_names.ALERT_ATTACK_DISCOVERY_MITRE_ATTACK_TACTICS]) ? attackDiscoveryAlertDocument[_field_names.ALERT_ATTACK_DISCOVERY_MITRE_ATTACK_TACTICS] : undefined,
    replacements: Array.isArray(attackDiscoveryAlertDocument[_field_names.ALERT_ATTACK_DISCOVERY_REPLACEMENTS]) ? (0, _elasticAssistantCommon.transformInternalReplacements)(attackDiscoveryAlertDocument[_field_names.ALERT_ATTACK_DISCOVERY_REPLACEMENTS]) : undefined,
    risk_score: attackDiscoveryAlertDocument[_field_names.ALERT_RISK_SCORE],
    summary_markdown: getFieldWithReplacementThenRender({
      replacementField: _field_names.ALERT_ATTACK_DISCOVERY_SUMMARY_MARKDOWN_WITH_REPLACEMENTS,
      normalField: _field_names.ALERT_ATTACK_DISCOVERY_SUMMARY_MARKDOWN,
      defaultValue: ''
    }),
    // required field
    timestamp: (0, _moment.default)(attackDiscoveryAlertDocument['@timestamp']).isValid() ? (0, _moment.default)(attackDiscoveryAlertDocument['@timestamp']).toISOString() : new Date().toISOString(),
    // required field
    title: getFieldWithReplacementThenRender({
      replacementField: _field_names.ALERT_ATTACK_DISCOVERY_TITLE_WITH_REPLACEMENTS,
      normalField: _field_names.ALERT_ATTACK_DISCOVERY_TITLE,
      defaultValue: ''
    }),
    // required field
    user_id: attackDiscoveryAlertDocument[_field_names.ALERT_ATTACK_DISCOVERY_USER_ID],
    user_name: attackDiscoveryAlertDocument[_field_names.ALERT_ATTACK_DISCOVERY_USER_NAME],
    users: Array.isArray(attackDiscoveryAlertDocument[_field_names.ALERT_ATTACK_DISCOVERY_USERS]) ? attackDiscoveryAlertDocument[_field_names.ALERT_ATTACK_DISCOVERY_USERS] : undefined
  };
};
exports.transformAttackDiscoveryAlertDocumentToApi = transformAttackDiscoveryAlertDocumentToApi;