"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformSearchResponseToAlerts = void 0;
var _is_missing_required_fields = require("./is_missing_required_fields");
var _transform_attack_discovery_alert_document_to_api = require("./transform_attack_discovery_alert_document_to_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const aggregationHasValue = aggregation => typeof aggregation === 'object' && aggregation !== null && 'value' in aggregation && typeof aggregation.value === 'number';
const transformSearchResponseToAlerts = ({
  enableFieldRendering,
  includeUniqueAlertIds = false,
  logger,
  response,
  withReplacements
}) => {
  var _response$aggregation, _response$aggregation2, _uniqueAttackAlertIds, _uniqueAttackAlertIds2, _response$aggregation3, _connectorNamesAggreg, _connectorNamesAggreg2;
  const data = response.hits.hits.flatMap(hit => {
    var _hit$_id;
    if (hit._source == null || (0, _is_missing_required_fields.isMissingRequiredFields)(hit)) {
      logger.warn(() => `Skipping Attack discovery alert document with id ${hit._id} in transformSearchResponseToAlerts because it's missing required fields.`);
      return []; // skip this hit
    }
    const source = hit._source;
    return (0, _transform_attack_discovery_alert_document_to_api.transformAttackDiscoveryAlertDocumentToApi)({
      attackDiscoveryAlertDocument: source,
      enableFieldRendering,
      id: (_hit$_id = hit._id) !== null && _hit$_id !== void 0 ? _hit$_id : '',
      withReplacements
    });
  });
  const uniqueAlertIdsCountAggregation = (_response$aggregation = response.aggregations) === null || _response$aggregation === void 0 ? void 0 : _response$aggregation.unique_alert_ids_count;
  const uniqueAlertIdsCount = aggregationHasValue(uniqueAlertIdsCountAggregation) ? uniqueAlertIdsCountAggregation.value : 0;
  const uniqueAttackAlertIdsAggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.all_attack_alert_ids;
  const uniqueAlertIds = includeUniqueAlertIds ? (_uniqueAttackAlertIds = uniqueAttackAlertIdsAggregation === null || uniqueAttackAlertIdsAggregation === void 0 ? void 0 : (_uniqueAttackAlertIds2 = uniqueAttackAlertIdsAggregation.buckets) === null || _uniqueAttackAlertIds2 === void 0 ? void 0 : _uniqueAttackAlertIds2.flatMap(bucket => {
    var _bucket$key;
    return (_bucket$key = bucket.key) !== null && _bucket$key !== void 0 ? _bucket$key : [];
  })) !== null && _uniqueAttackAlertIds !== void 0 ? _uniqueAttackAlertIds : [] : [];
  const connectorNamesAggregation = (_response$aggregation3 = response.aggregations) === null || _response$aggregation3 === void 0 ? void 0 : _response$aggregation3.api_config_name;
  const connectorNames = (_connectorNamesAggreg = connectorNamesAggregation === null || connectorNamesAggregation === void 0 ? void 0 : (_connectorNamesAggreg2 = connectorNamesAggregation.buckets) === null || _connectorNamesAggreg2 === void 0 ? void 0 : _connectorNamesAggreg2.flatMap(bucket => {
    var _bucket$key2;
    return (_bucket$key2 = bucket.key) !== null && _bucket$key2 !== void 0 ? _bucket$key2 : [];
  })) !== null && _connectorNamesAggreg !== void 0 ? _connectorNamesAggreg : [];
  return {
    connectorNames: [...connectorNames].sort(),
    // mutation
    data,
    uniqueAlertIdsCount,
    uniqueAlertIds
  };
};
exports.transformSearchResponseToAlerts = transformSearchResponseToAlerts;