"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConversation = void 0;
var _transforms = require("./transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConversation = async ({
  esClient,
  logger,
  conversationIndex,
  id,
  user
}) => {
  const filterByUser = user ? [{
    nested: {
      path: 'users',
      query: {
        bool: {
          must: [{
            match: user.username ? {
              'users.name': user.username
            } : {
              'users.id': user.profile_uid
            }
          }]
        }
      }
    }
  }] : [];
  try {
    var _conversation$;
    const response = await esClient.search({
      query: {
        bool: {
          must: [{
            bool: {
              should: [{
                term: {
                  _id: id
                }
              }]
            }
          }],
          filter: [{
            bool: {
              should: [...filterByUser,
              // global users
              {
                bool: {
                  must_not: [{
                    nested: {
                      path: 'users',
                      query: {
                        match_all: {}
                      }
                    }
                  }]
                }
              }],
              minimum_should_match: 1
            }
          }]
        }
      },
      _source: true,
      ignore_unavailable: true,
      index: conversationIndex,
      seq_no_primary_term: true
    });
    const conversation = (0, _transforms.transformESSearchToConversations)(response);
    return (_conversation$ = conversation[0]) !== null && _conversation$ !== void 0 ? _conversation$ : null;
  } catch (err) {
    logger.error(`Error fetching conversation: ${err} with id: ${id}`);
    throw err;
  }
};
exports.getConversation = getConversation;