"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformAttackDiscoveryScheduleFromApi = void 0;
var _transform_attack_discovery_schedule_actions_props_from_api = require("../transform_attack_discovery_schedule_actions_props_from_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformAttackDiscoveryScheduleFromApi = api => {
  var _transformAttackDisco;
  return {
    id: api.id,
    name: api.name,
    createdBy: api.created_by,
    updatedBy: api.updated_by,
    createdAt: api.created_at,
    updatedAt: api.updated_at,
    enabled: api.enabled,
    params: {
      alertsIndexPattern: api.params.alerts_index_pattern,
      apiConfig: api.params.api_config,
      end: api.params.end,
      query: api.params.query,
      filters: api.params.filters,
      combinedFilter: api.params.combined_filter,
      size: api.params.size,
      start: api.params.start
    },
    schedule: api.schedule,
    actions: (_transformAttackDisco = (0, _transform_attack_discovery_schedule_actions_props_from_api.transformAttackDiscoveryScheduleActionsPropsFromApi)(api.actions)) !== null && _transformAttackDisco !== void 0 ? _transformAttackDisco : [],
    lastExecution: api.last_execution
  };
};
exports.transformAttackDiscoveryScheduleFromApi = transformAttackDiscoveryScheduleFromApi;