"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTracesContextService = exports.createTracesContextService = exports.DEFAULT_ALLOWED_TRACES_BASE_PATTERNS_REGEXP = exports.DEFAULT_ALLOWED_TRACES_BASE_PATTERNS = void 0;
var _dataViewUtils = require("@kbn/data-view-utils");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DEFAULT_ALLOWED_TRACES_BASE_PATTERNS = exports.DEFAULT_ALLOWED_TRACES_BASE_PATTERNS = ['trace', 'traces'];
const DEFAULT_ALLOWED_TRACES_BASE_PATTERNS_REGEXP = exports.DEFAULT_ALLOWED_TRACES_BASE_PATTERNS_REGEXP = (0, _dataViewUtils.createRegExpPatternFrom)(DEFAULT_ALLOWED_TRACES_BASE_PATTERNS, 'data');
const createTracesContextService = ({
  indices
}) => {
  if (!indices) {
    return defaultTracesContextService;
  }
  const {
    transaction,
    span
  } = indices;
  const allTraceIndices = getAllIndices(transaction, span);
  const tracesIndexPattern = allTraceIndices.join();
  const allowedDataSources = [...allTraceIndices, DEFAULT_ALLOWED_TRACES_BASE_PATTERNS_REGEXP];
  return getTracesContextService({
    tracesIndexPattern,
    allowedDataSources
  });
};
exports.createTracesContextService = createTracesContextService;
function getAllIndices(transaction, span) {
  return Array.from(new Set([transaction, span].flatMap(index => index.split(','))));
}
const getTracesContextService = ({
  tracesIndexPattern,
  allowedDataSources
}) => ({
  getAllTracesIndexPattern: () => tracesIndexPattern,
  isTracesIndexPattern: (0, _dataViewUtils.testPatternAgainstAllowedList)(allowedDataSources),
  containsTracesIndexPattern: (0, _utils.containsIndexPattern)(allowedDataSources)
});
exports.getTracesContextService = getTracesContextService;
const defaultTracesContextService = getTracesContextService({
  tracesIndexPattern: undefined,
  allowedDataSources: [DEFAULT_ALLOWED_TRACES_BASE_PATTERNS_REGEXP]
});