"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedSearchURLConflictCallout = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/saved-search-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SavedSearchURLConflictCallout = ({
  discoverSession,
  spaces,
  history
}) => {
  var _discoverSession$shar;
  if (spaces && discoverSession !== null && discoverSession !== void 0 && discoverSession.id && (discoverSession === null || discoverSession === void 0 ? void 0 : (_discoverSession$shar = discoverSession.sharingSavedObjectProps) === null || _discoverSession$shar === void 0 ? void 0 : _discoverSession$shar.outcome) === 'conflict') {
    var _discoverSession$shar2;
    const otherObjectId = (_discoverSession$shar2 = discoverSession.sharingSavedObjectProps) === null || _discoverSession$shar2 === void 0 ? void 0 : _discoverSession$shar2.aliasTargetId;
    if (otherObjectId) {
      return spaces.ui.components.getLegacyUrlConflict({
        objectNoun: _i18n.i18n.translate('discover.savedSearchURLConflictCallout.objectNoun', {
          defaultMessage: `''{savedSearch}'' Discover session`,
          values: {
            savedSearch: discoverSession.title
          }
        }),
        currentObjectId: discoverSession.id,
        otherObjectPath: `${(0, _public.getSavedSearchUrl)(otherObjectId)}${history.location.search}`,
        otherObjectId
      });
    }
  }
  return null;
};
exports.SavedSearchURLConflictCallout = SavedSearchURLConflictCallout;