"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenSearchPanel = OpenSearchPanel;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("@kbn/saved-search-plugin/common");
var _public = require("@kbn/saved-objects-finder-plugin/public");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/top_nav/open_search_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function OpenSearchPanel(props) {
  var _capabilities$savedOb, _capabilities$savedOb2;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    addBasePath,
    capabilities,
    savedObjectsTagging,
    contentClient,
    uiSettings
  } = (0, _use_discover_services.useDiscoverServices)();
  const hasSavedObjectPermission = ((_capabilities$savedOb = capabilities.savedObjectsManagement) === null || _capabilities$savedOb === void 0 ? void 0 : _capabilities$savedOb.edit) || ((_capabilities$savedOb2 = capabilities.savedObjectsManagement) === null || _capabilities$savedOb2 === void 0 ? void 0 : _capabilities$savedOb2.delete);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "aria-labelledby": modalTitleId,
    ownFocus: true,
    onClose: props.onClose,
    "data-test-subj": "loadSearchForm",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: modalTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.topNav.openSearchPanel.openSearchTitle",
    defaultMessage: "Open Discover session",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public.SavedObjectFinder, {
    id: "discoverOpenSearch",
    services: {
      savedObjectsTagging,
      contentClient,
      uiSettings
    },
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.topNav.openSearchPanel.noSearchesFoundDescription",
      defaultMessage: "No matching Discover sessions found.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 13
      }
    }),
    savedObjectMetaData: [{
      type: _common.SavedSearchType,
      getIconForSavedObject: () => 'discoverApp',
      name: _i18n.i18n.translate('discover.savedSearch.savedObjectName', {
        defaultMessage: 'Discover session'
      })
    }],
    onChoose: id => {
      props.onOpenSavedSearch(id);
      props.onClose();
    },
    showFilter: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  })), hasSavedObjectPermission && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: props.onClose,
    "data-test-subj": "manageSearchesBtn",
    href: addBasePath(`/app/management/kibana/objects?initialQuery=type:("${_common.SavedSearchTypeDisplayName}")`),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.topNav.openSearchPanel.manageSearchesButtonLabel",
    defaultMessage: "Manage Discover sessions",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 17
    }
  }))))));
}