"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasActiveFilter = hasActiveFilter;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Returns if true there's at least 1 active filter
 */
function hasActiveFilter(filters) {
  return filters && filters.filter(f => {
    var _f$meta;
    return !((_f$meta = f.meta) !== null && _f$meta !== void 0 && _f$meta.disabled);
  }).length > 0;
}