"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchSessionsMgmtApp = void 0;
Object.defineProperty(exports, "renderApp", {
  enumerable: true,
  get: function () {
    return _render.renderApp;
  }
});
var _ = require("..");
var _api = require("../lib/api");
var _documentation = require("../lib/documentation");
var _render = require("./render");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class SearchSessionsMgmtApp {
  constructor(coreSetup, setupDeps, config, kibanaVersion, params) {
    this.coreSetup = coreSetup;
    this.setupDeps = setupDeps;
    this.config = config;
    this.kibanaVersion = kibanaVersion;
    this.params = params;
  }
  async mountManagementSection() {
    const {
      coreSetup,
      params,
      setupDeps
    } = this;
    const [coreStart, pluginsStart] = await coreSetup.getStartServices();
    const {
      chrome: {
        docTitle
      },
      http,
      docLinks,
      i18n,
      notifications,
      uiSettings,
      application
    } = coreStart;
    const pluginName = _.APP.getI18nName();
    docTitle.change(pluginName);
    this.params.setBreadcrumbs([{
      text: pluginName
    }]);
    const api = new _api.SearchSessionsMgmtAPI(setupDeps.sessionsClient, this.config, {
      notifications,
      application,
      usageCollector: setupDeps.searchUsageCollector,
      featureFlags: coreStart.featureFlags
    });
    const documentation = new _documentation.AsyncSearchIntroDocumentation(docLinks);
    const dependencies = {
      config: this.config,
      documentation,
      core: coreStart,
      api,
      http,
      i18n,
      uiSettings,
      share: pluginsStart.share,
      kibanaVersion: this.kibanaVersion,
      searchUsageCollector: setupDeps.searchUsageCollector
    };
    const {
      element
    } = params;
    const unmountAppCb = (0, _render.renderApp)(element, dependencies);
    return () => {
      docTitle.reset();
      unmountAppCb();
    };
  }
}
exports.SearchSessionsMgmtApp = SearchSessionsMgmtApp;