"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkdownRenderer = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard_markdown/public/components/markdown_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const markdownRendererStyles = {
  container: ({
    euiTheme
  }) => (0, _react2.css)({
    padding: euiTheme.size.base,
    width: '100%',
    overflowWrap: 'break-word',
    img: {
      maxInlineSize: '100%'
    }
  })
};
const MarkdownRenderer = ({
  content,
  processingPluginList
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(markdownRendererStyles);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    className: "eui-yScroll",
    "data-test-subj": "markdownRenderer",
    processingPluginList: processingPluginList,
    css: styles.container,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, content);
};
exports.MarkdownRenderer = MarkdownRenderer;