"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.controlWidthSchema = exports.controlSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _controlsConstants = require("@kbn/controls-constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const controlWidthSchema = exports.controlWidthSchema = _configSchema.schema.oneOf([_configSchema.schema.literal(_controlsConstants.CONTROL_WIDTH_SMALL), _configSchema.schema.literal(_controlsConstants.CONTROL_WIDTH_MEDIUM), _configSchema.schema.literal(_controlsConstants.CONTROL_WIDTH_LARGE)], {
  defaultValue: _controlsConstants.DEFAULT_CONTROL_WIDTH,
  meta: {
    description: 'Minimum width of the control panel in the control group.'
  }
});
const controlSchema = exports.controlSchema = _configSchema.schema.object({
  type: _configSchema.schema.string({
    meta: {
      description: 'The type of the control panel.'
    }
  }),
  controlConfig: _configSchema.schema.maybe(_configSchema.schema.object({}, {
    unknowns: 'allow'
  })),
  id: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'The unique ID of the control.'
    }
  })),
  order: _configSchema.schema.number({
    meta: {
      description: 'The order of the control panel in the control group.'
    }
  }),
  width: _configSchema.schema.maybe(controlWidthSchema),
  grow: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: _controlsConstants.DEFAULT_CONTROL_GROW,
    meta: {
      description: 'Expand width of the control panel to fit available space.'
    }
  }))
}, {
  unknowns: 'allow'
});