"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilitySeverityMap = void 0;
var _react = _interopRequireDefault(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _use_get_severity_status_color = require("@kbn/cloud-security-posture/src/hooks/use_get_severity_status_color");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/vulnerability_severity_map.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const formatPercentage = percentage => {
  if (percentage === 0) {
    return '0%';
  }
  if (percentage === 100) {
    return '100%';
  }
  return `${percentage.toFixed(1)}%`;
};
const VulnerabilitySeverityMap = ({
  severityMap,
  total
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    getSeverityStatusColor
  } = (0, _use_get_severity_status_color.useGetSeverityStatusColor)();
  const severityMapPallet = [];
  const severityMapTooltip = [];
  if (total > 0) {
    // Setting a minimum stop value of 8% the palette bar to avoid the color
    // palette being too small to be visible
    const minStop = Math.max(0.08 * total, 1);
    const severityLevels = ['low', 'medium', 'high', 'critical'];
    let currentStop = 0;
    severityLevels.forEach(severity => {
      if (severityMap[severity] > 0) {
        currentStop += Math.max(severityMap[severity], minStop);
        severityMapPallet.push({
          stop: currentStop,
          color: getSeverityStatusColor(severity.toUpperCase())
        });
      }
      severityMapTooltip.push({
        severity,
        count: severityMap[severity],
        percentage: severityMap[severity] / total * 100
      });
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    className: (0, _css.css)`
        width: 256px;
      `,
    anchorClassName: (0, _css.css)`
        margin-left: ${euiTheme.size.xs};
      `,
    position: "left",
    title: _i18n.i18n.translate('xpack.csp.vulnerabilitiesByResource.severityMap.tooltipTitle', {
      defaultMessage: 'Severity map'
    }),
    content: /*#__PURE__*/_react.default.createElement(TooltipBody, {
      severityMapTooltip: severityMapTooltip,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 16
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPaletteDisplay, {
    type: "fixed",
    palette: severityMapPallet,
    className: (0, _css.css)`
          width: 80px;
          height: 6px;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }));
};
exports.VulnerabilitySeverityMap = VulnerabilitySeverityMap;
const TooltipBody = ({
  severityMapTooltip
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, severityMapTooltip.map(severity => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    key: severity.severity,
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.SeverityStatusBadge, {
    severity: severity.severity.toUpperCase(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 17
    }
  }, severity.count)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "right",
    size: "s",
    className: (0, _css.css)`
                    width: ${euiTheme.size.xxxl};
                    color: ${euiTheme.colors.mediumShade};
                  `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 17
    }
  }, formatPercentage(severity.percentage))))))));
};