"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerCAISchedulerTask = registerCAISchedulerTask;
exports.scheduleCAISchedulerTask = scheduleCAISchedulerTask;
var _server = require("@kbn/core/server");
var _constants = require("../../../../common/constants");
var _scheduler_task_factory = require("./scheduler_task_factory");
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerCAISchedulerTask({
  taskManager,
  logger,
  core,
  analyticsConfig
}) {
  const getUnsecureSavedObjectsClient = async () => {
    const [{
      savedObjects
    }] = await core.getStartServices();
    const internalSavedObjectsRepository = savedObjects.createInternalRepository([_constants.CASE_SAVED_OBJECT]);
    return new _server.SavedObjectsClient(internalSavedObjectsRepository);
  };
  const getTaskManager = async () => {
    const plugins = await core.plugins.onStart('taskManager');
    if (plugins.taskManager.found) {
      return plugins.taskManager.contract;
    }
    throw new Error('Could not get taskManager start contract');
  };
  const getESClient = async () => {
    const [{
      elasticsearch
    }] = await core.getStartServices();
    return elasticsearch.client.asInternalUser;
  };
  taskManager.registerTaskDefinitions({
    [_constants.ANALYTICS_SCHEDULER_TASK_TYPE]: {
      title: 'Schedules cases analytics synchronization tasks.',
      maxAttempts: 3,
      createTaskRunner: () => {
        return new _scheduler_task_factory.AnalyticsIndexSchedulerTaskFactory({
          getUnsecureSavedObjectsClient,
          getTaskManager,
          logger,
          analyticsConfig,
          getESClient
        }).create();
      }
    }
  });
}
async function scheduleCAISchedulerTask({
  taskManager,
  logger
}) {
  try {
    await taskManager.ensureScheduled({
      id: _constants2.CAI_SCHEDULER_TASK_ID,
      taskType: _constants.ANALYTICS_SCHEDULER_TASK_TYPE,
      params: {},
      runAt: new Date(Date.now() + 60 * 1000),
      schedule: {
        interval: '1h'
      },
      state: {}
    });
  } catch (e) {
    logger.error(`Error scheduling ${_constants2.CAI_SCHEDULER_TASK_ID} task, received ${e.message}`);
  }
}