"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _builder = require("./builder");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/custom_fields/form_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fieldTypeSelectOptions = () => {
  const options = [];
  for (const [id, builder] of Object.entries(_builder.builderMap)) {
    const createdBuilder = builder();
    options.push({
      value: id,
      text: createdBuilder.label
    });
  }
  return options;
};
const FormFieldsComponent = ({
  isSubmitting,
  isEditMode
}) => {
  const [{
    type
  }] = (0, _hook_form_lib.useFormData)();
  const builtCustomField = (0, _react.useMemo)(() => {
    const builder = _builder.builderMap[type];
    if (builder == null) {
      return null;
    }
    const customFieldBuilder = builder();
    return customFieldBuilder.build();
  }, [type]);
  const Configure = builtCustomField === null || builtCustomField === void 0 ? void 0 : builtCustomField.Configure;
  const options = fieldTypeSelectOptions();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "key",
    component: _components.HiddenField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "label",
    component: _components.TextField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'custom-field-label-input',
        fullWidth: true,
        // Setting autoFocus to false in order to preserve the correct focus when modal is closed
        autoFocus: false,
        isLoading: isSubmitting
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    component: _components.SelectField,
    path: "type",
    componentProps: {
      euiFieldProps: {
        options,
        'data-test-subj': 'custom-field-type-selector',
        isLoading: isSubmitting,
        disabled: isEditMode
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }), Configure ? /*#__PURE__*/_react.default.createElement(Configure, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 20
    }
  }) : null);
};
FormFieldsComponent.displayName = 'FormFields';
const FormFields = exports.FormFields = /*#__PURE__*/(0, _react.memo)(FormFieldsComponent);