"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseViewSimilarCases = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_get_similar_cases = require("../../../containers/use_get_similar_cases");
var _types = require("../../../../common/types");
var _case_view_tabs = require("../case_view_tabs");
var _types2 = require("../../all_cases/types");
var _table = require("../../similar_cases/table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/case_view/components/case_view_similar_cases.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CaseViewSimilarCases = ({
  caseData
}) => {
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(_types2.CASES_TABLE_PER_PAGE_VALUES[0]);
  const {
    data = _use_get_similar_cases.initialData,
    isLoading: isLoadingCases
  } = (0, _use_get_similar_cases.useGetSimilarCases)({
    caseId: caseData.id,
    page: pageIndex + 1,
    perPage: pageSize,
    enabled: true
  });
  const tableOnChangeCallback = (0, _react.useCallback)(({
    page,
    sort
  }) => {
    setPageIndex(page.index);
    setPageSize(page.size);
  }, []);
  const pagination = (0, _react.useMemo)(() => {
    var _data$total;
    return {
      pageIndex,
      pageSize,
      totalItemCount: (_data$total = data.total) !== null && _data$total !== void 0 ? _data$total : 0,
      pageSizeOptions: _types2.CASES_TABLE_PER_PAGE_VALUES
    };
  }, [data.total, pageIndex, pageSize]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_case_view_tabs.CaseViewTabs, {
    caseData: caseData,
    activeTab: _types.CASE_VIEW_PAGE_TABS.SIMILAR_CASES,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_table.SimilarCasesTable, {
    isLoading: isLoadingCases,
    cases: data.cases,
    pagination: pagination,
    onChange: tableOnChangeCallback,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 13
    }
  })))));
};
exports.CaseViewSimilarCases = CaseViewSimilarCases;
CaseViewSimilarCases.displayName = 'CaseViewObservables';