"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesTableFilters = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _more_filters_selectable = require("./table_filter_config/more_filters_selectable");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_get_tags = require("../../containers/use_get_tags");
var _use_get_categories = require("../../containers/use_get_categories");
var _use_cases_features = require("../../common/use_cases_features");
var _use_system_filter_config = require("./table_filter_config/use_system_filter_config");
var _use_filter_config = require("./table_filter_config/use_filter_config");
var _use_get_case_configuration = require("../../containers/configure/use_get_case_configuration");
var _search = require("./search");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/all_cases/table_filters.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const mergeCustomizer = (objValue, srcValue, key) => {
  if (Array.isArray(objValue)) {
    return srcValue;
  }
};
const CasesTableFiltersComponent = ({
  countClosedCases,
  countOpenCases,
  countInProgressCases,
  onFilterChanged,
  hiddenStatuses,
  availableSolutions,
  isSelectorView = false,
  onCreateCasePressed,
  isLoading,
  currentUserProfile,
  filterOptions
}) => {
  const {
    data: tags = [],
    isLoading: isLoadingTags
  } = (0, _use_get_tags.useGetTags)();
  const {
    data: categories = [],
    isLoading: isLoadingCategories
  } = (0, _use_get_categories.useGetCategories)();
  const {
    caseAssignmentAuthorized
  } = (0, _use_cases_features.useCasesFeatures)();
  const {
    data: {
      customFields
    },
    isFetching: isLoadingCasesConfiguration
  } = (0, _use_get_case_configuration.useGetCaseConfiguration)();
  const onFilterOptionsChange = (0, _react.useCallback)(partialFilterOptions => {
    const newFilterOptions = (0, _lodash.mergeWith)({}, filterOptions, partialFilterOptions, mergeCustomizer);
    if (!(0, _lodash.isEqual)(newFilterOptions, filterOptions)) {
      onFilterChanged(newFilterOptions);
    }
  }, [filterOptions, onFilterChanged]);
  const isLoadingFilters = isLoading || isLoadingTags || isLoadingCategories || isLoadingCasesConfiguration;
  const {
    systemFilterConfig
  } = (0, _use_system_filter_config.useSystemFilterConfig)({
    availableSolutions,
    caseAssignmentAuthorized,
    categories,
    countClosedCases,
    countInProgressCases,
    countOpenCases,
    currentUserProfile,
    hiddenStatuses,
    isLoading: isLoadingFilters,
    isSelectorView,
    onFilterOptionsChange,
    tags
  });
  const {
    filters: activeFilters,
    selectableOptions,
    activeSelectableOptionKeys,
    onFilterConfigChange
  } = (0, _use_filter_config.useFilterConfig)({
    systemFilterConfig,
    onFilterOptionsChange,
    isSelectorView,
    filterOptions,
    customFields,
    isLoading: isLoadingFilters
  });
  const handleOnCreateCasePressed = (0, _react.useCallback)(() => {
    if (onCreateCasePressed) {
      onCreateCasePressed();
    }
  }, [onCreateCasePressed]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexStart",
    wrap: true,
    "data-test-subj": "cases-table-filters",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 5
    }
  }, isSelectorView && onCreateCasePressed ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: handleOnCreateCasePressed,
    iconType: "plusInCircle",
    "data-test-subj": "cases-table-add-case-filter-bar",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }, i18n.CREATE_CASE_TITLE)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_search.TableSearch, {
    filterOptionsSearch: filterOptions.search
    /**
     * we need this to reset the internal state of the
     * TableSearch component each time the search in
     * the all cases state changes
     */,
    key: filterOptions.search,
    onFilterOptionsChange: onFilterOptionsChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  })), activeFilters.map(filter => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: filter.key,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }, filter.render({
    filterOptions
  }))), isSelectorView || /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_more_filters_selectable.MoreFiltersSelectable, {
    options: selectableOptions,
    activeFilters: activeSelectableOptionKeys,
    onChange: onFilterConfigChange,
    isLoading: isLoadingFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 11
    }
  })));
};
CasesTableFiltersComponent.displayName = 'CasesTableFiltersComponent';
const CasesTableFilters = exports.CasesTableFilters = /*#__PURE__*/_react.default.memo(CasesTableFiltersComponent);
CasesTableFilters.displayName = 'CasesTableFilters';