"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Loading = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _hex_to_rgb = require("../../../common/lib/hex_to_rgb");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/loading/loading.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Loading = ({
  animated = false,
  text = '',
  backgroundColor = '#000000'
}) => {
  if (animated) {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "canvasLoading",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 7
      }
    }, text && /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 11
      }
    }, text, "\xA0"), /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 9
      }
    }));
  }
  const rgb = (0, _hex_to_rgb.hexToRgb)(backgroundColor);
  let color = 'text';
  if (rgb && (0, _eui.isColorDark)(rgb[0], rgb[1], rgb[2])) {
    color = 'ghost';
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasLoading",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, text && /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  }, text, "\xA0"), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: color,
    type: "clock",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }));
};
exports.Loading = Loading;
Loading.propTypes = {
  animated: _propTypes.default.bool,
  backgroundColor: _propTypes.default.string,
  text: _propTypes.default.string
};
Loading.defaultProps = {
  animated: false,
  backgroundColor: '#000000',
  text: ''
};