"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getErrorRenderer = exports.errorRendererFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
var _public = require("@kbn/presentation-util-plugin/public");
var _components = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/canvas_plugin_src/renderers/error/error_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const errorStrings = {
  getDisplayName: () => _i18n.i18n.translate('xpack.canvas.renderer.error.displayName', {
    defaultMessage: 'Error information'
  }),
  getHelpDescription: () => _i18n.i18n.translate('xpack.canvas.renderer.error.helpDescription', {
    defaultMessage: 'Render error data in a way that is helpful to users'
  })
};
const ErrorComponent = (0, _public.withSuspense)(_components.LazyErrorRenderComponent);
const getErrorRenderer = core => () => ({
  name: 'error',
  displayName: errorStrings.getDisplayName(),
  help: errorStrings.getHelpDescription(),
  reuseDomNode: true,
  render: async (domNode, config, handlers) => {
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundaryProvider, {
      analytics: undefined,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundary, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, (0, _extends2.default)({}, core, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(ErrorComponent, (0, _extends2.default)({
      onLoaded: handlers.done
    }, config, {
      parentNode: domNode,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 17
      }
    })))))), domNode);
  }
});
exports.getErrorRenderer = getErrorRenderer;
const errorRendererFactory = core => getErrorRenderer(core);
exports.errorRendererFactory = errorRendererFactory;