"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Origin = void 0;
exports.revealImage = revealImage;
var _reveal_image = require("../../../i18n/functions/dict/reveal_image");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let Origin = exports.Origin = /*#__PURE__*/function (Origin) {
  Origin["TOP"] = "top";
  Origin["LEFT"] = "left";
  Origin["BOTTOM"] = "bottom";
  Origin["RIGHT"] = "right";
  return Origin;
}({});
function revealImage() {
  const {
    help,
    args: argHelp
  } = _reveal_image.help;
  return {
    name: 'revealImage',
    aliases: [],
    type: 'render',
    inputTypes: ['number'],
    help,
    args: {
      image: {
        types: ['string', 'null'],
        help: argHelp.image,
        default: null
      },
      emptyImage: {
        types: ['string', 'null'],
        help: argHelp.emptyImage,
        default: null
      },
      origin: {
        types: ['string'],
        help: argHelp.origin,
        default: 'bottom',
        options: Object.values(Origin)
      }
    },
    fn: async (percent, args) => {
      if (percent > 1 || percent < 0) {
        throw _reveal_image.errors.invalidPercent(percent);
      }
      const {
        resolveWithMissingImage,
        elasticOutline,
        isValidUrl
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../../public/lib')));
      if (args.image && !isValidUrl(args.image)) {
        throw _reveal_image.errors.invalidImageUrl(args.image);
      }
      return {
        type: 'render',
        as: 'revealImage',
        value: {
          percent,
          ...args,
          image: resolveWithMissingImage(args.image, elasticOutline),
          emptyImage: resolveWithMissingImage(args.emptyImage)
        }
      };
    }
  };
}