"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStacktracesIdsField = getStacktracesIdsField;
var _common = require("@kbn/observability-plugin/common");
var _server = require("@kbn/observability-plugin/server");
var _lodash = require("lodash");
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _apm = require("../../../common/es_fields/apm");
var _environment_query = require("../../../common/utils/environment_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getStacktracesIdsField({
  apmEventClient,
  start,
  end,
  environment,
  serviceName,
  transactionType,
  transactionName,
  kuery
}) {
  var _response$hits$hits$;
  const response = await apmEventClient.search('get_stacktraces_ids_field', {
    apm: {
      events: [_common.ProcessorEvent.transaction]
    },
    size: 1,
    terminate_after: 1,
    track_total_hits: false,
    fields: [_apm.ELASTIC_PROFILER_STACK_TRACE_IDS, _apm.TRANSACTION_PROFILER_STACK_TRACE_IDS],
    _source: false,
    query: {
      bool: {
        filter: [...(0, _server.rangeQuery)(start, end), ...(0, _server.termQuery)(_apm.SERVICE_NAME, serviceName), ...(0, _server.termQuery)(_apm.TRANSACTION_TYPE, transactionType), ...(0, _server.termQuery)(_apm.TRANSACTION_NAME, transactionName), ...(0, _server.kqlQuery)(kuery), ...(0, _environment_query.environmentQuery)(environment)],
        should: [{
          exists: {
            field: _apm.ELASTIC_PROFILER_STACK_TRACE_IDS
          }
        }, {
          exists: {
            field: _apm.TRANSACTION_PROFILER_STACK_TRACE_IDS
          }
        }]
      }
    }
  });
  const field = (0, _utils.unflattenKnownApmEventFields)((_response$hits$hits$ = response.hits.hits[0]) === null || _response$hits$hits$ === void 0 ? void 0 : _response$hits$hits$.fields, [_apm.ELASTIC_PROFILER_STACK_TRACE_IDS]);
  if (!(0, _lodash.isEmpty)(field.elastic.profiler_stack_trace_ids)) {
    return _apm.ELASTIC_PROFILER_STACK_TRACE_IDS;
  }
  return _apm.TRANSACTION_PROFILER_STACK_TRACE_IDS;
}