"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceCorrelationFields = getServiceCorrelationFields;
var _server = require("@kbn/observability-plugin/server");
var _apm = require("../../../common/es_fields/apm");
var _environment_query = require("../../../common/utils/environment_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getBucketKeysAsString = buckets => (buckets === null || buckets === void 0 ? void 0 : buckets.map(bucket => bucket.key)) || [];
async function getServiceCorrelationFields({
  apmEventClient,
  serviceName,
  start,
  end,
  environment,
  documentType,
  rollupInterval
}) {
  var _response$aggregation, _response$aggregation2, _response$aggregation3;
  const response = await apmEventClient.search('get_service_host_names', {
    apm: {
      sources: [{
        documentType,
        rollupInterval
      }]
    },
    track_total_hits: false,
    size: 0,
    query: {
      bool: {
        filter: [{
          term: {
            [_apm.SERVICE_NAME]: serviceName
          }
        }, ...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment)]
      }
    },
    aggs: {
      hostHostNames: {
        terms: {
          field: _apm.HOST_HOSTNAME,
          size: 500
        }
      },
      hostNames: {
        terms: {
          field: _apm.HOST_NAME,
          size: 500
        }
      },
      containerIds: {
        terms: {
          field: _apm.CONTAINER_ID,
          size: 500
        }
      }
    }
  });
  const allHostNames = [...getBucketKeysAsString((_response$aggregation = response.aggregations) === null || _response$aggregation === void 0 ? void 0 : _response$aggregation.hostHostNames.buckets), ...getBucketKeysAsString((_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.hostNames.buckets)];
  const hostNames = new Set(allHostNames);
  return {
    hostNames: Array.from(hostNames),
    containerIds: getBucketKeysAsString((_response$aggregation3 = response.aggregations) === null || _response$aggregation3 === void 0 ? void 0 : _response$aggregation3.containerIds.buckets)
  };
}