"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCustomDashboards = getCustomDashboards;
var _custom_dashboards = require("../../../common/custom_dashboards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getCustomDashboards({
  savedObjectsClient
}) {
  const result = await savedObjectsClient.find({
    type: _custom_dashboards.APM_CUSTOM_DASHBOARDS_SAVED_OBJECT_TYPE,
    page: 1,
    perPage: 1000,
    sortField: 'updated_at',
    sortOrder: 'desc'
  });
  return result.saved_objects.map(({
    id,
    attributes,
    updated_at: upatedAt
  }) => ({
    id,
    updatedAt: upatedAt ? Date.parse(upatedAt) : 0,
    ...attributes
  }));
}