"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.softDeleteGapsBatch = void 0;
var _update_gaps_in_event_log = require("../update/update_gaps_in_event_log");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const softDeleteGapsBatch = async ({
  gaps,
  alertingEventLogger,
  logger,
  eventLogClient
}) => {
  // Convert gaps to the format expected by updateDocuments
  const prepareGaps = async gapsToUpdate => {
    return gapsToUpdate.map(gap => {
      if (!gap.internalFields) return null;
      return {
        gap: {
          ...gap.toObject(),
          deleted: true
        },
        internalFields: gap.internalFields
      };
    }).filter(gap => gap !== null);
  };
  return (0, _update_gaps_in_event_log.updateGapsInEventLog)({
    gaps,
    prepareGaps,
    alertingEventLogger,
    logger,
    eventLogClient
  });
};
exports.softDeleteGapsBatch = softDeleteGapsBatch;