"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysisPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _mlUrlState = require("@kbn/ml-url-state");
var _state = require("@kbn/aiops-log-rate-analysis/state");
var _log_rate_analysis_type = require("@kbn/aiops-log-rate-analysis/log_rate_analysis_type");
var _use_data_source = require("../../hooks/use_data_source");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _use_data = require("../../hooks/use_data");
var _use_search = require("../../hooks/use_search");
var _log_rate_analysis = require("../../application/url_state/log_rate_analysis");
var _search_panel = require("../search_panel");
var _page_header = require("../page_header");
var _log_rate_analysis_content = require("./log_rate_analysis_content/log_rate_analysis_content");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_rate_analysis/log_rate_analysis_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LogRateAnalysisPage = ({
  showContextualInsights = false
}) => {
  const aiopsAppContext = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    data: dataService,
    observabilityAIAssistant
  } = aiopsAppContext;
  const {
    dataView,
    savedSearch
  } = (0, _use_data_source.useDataSource)();
  const currentSelectedGroup = (0, _state.useCurrentSelectedGroup)();
  const currentSelectedSignificantItem = (0, _state.useCurrentSelectedSignificantItem)();
  const dispatch = (0, _state.useAppDispatch)();
  const [stateFromUrl, setUrlState] = (0, _mlUrlState.usePageUrlState)('logRateAnalysis', (0, _log_rate_analysis.getDefaultLogRateAnalysisAppState)());
  const [globalState, setGlobalState] = (0, _mlUrlState.useUrlState)('_g');
  const [selectedSavedSearch, setSelectedSavedSearch] = (0, _react.useState)(savedSearch);

  // Used to store analysis results to be passed on to the AI Assistant.
  const [logRateAnalysisParams, setLogRateAnalysisParams] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    if (savedSearch) {
      setSelectedSavedSearch(savedSearch);
    }
  }, [savedSearch]);
  const setSearchParams = (0, _react.useCallback)(searchParams => {
    // When the user loads a saved search and then clears or modifies the query
    // we should remove the saved search and replace it with the index pattern id
    if (selectedSavedSearch !== null) {
      setSelectedSavedSearch(null);
    }
    setUrlState({
      ...stateFromUrl,
      searchQuery: searchParams.searchQuery,
      searchString: searchParams.searchString,
      searchQueryLanguage: searchParams.queryLanguage,
      filters: searchParams.filters
    });
  }, [selectedSavedSearch, stateFromUrl, setUrlState]);
  const {
    searchQueryLanguage,
    searchString,
    searchQuery
  } = (0, _use_search.useSearch)({
    dataView,
    savedSearch
  }, stateFromUrl);
  const {
    documentStats,
    timefilter,
    earliest,
    latest,
    intervalMs
  } = (0, _use_data.useData)(dataView, 'log_rate_analysis', searchQuery, setGlobalState, currentSelectedSignificantItem, currentSelectedGroup);

  // TODO Since `useData` isn't just used within Log Rate Analysis, this is a bit of
  // a workaround to pass the result on to the redux store. At least this ensures
  // we now use `useData` only once across Log Rate Analysis! Originally `useData`
  // was quite general, but over time it got quite some specific features used
  // across Log Rate Analysis and Pattern Analysis. We discussed that we should
  // split this up into more specific hooks.
  (0, _react.useEffect)(() => {
    dispatch((0, _state.setDocumentCountChartData)({
      earliest,
      latest,
      intervalMs,
      documentStats
    }));
  }, [documentStats, dispatch, earliest, intervalMs, latest]);
  (0, _react.useEffect)(
  // TODO: Consolidate this hook/function with the one in `x-pack/plugins/private/data_visualizer/public/application/index_data_visualizer/components/index_data_visualizer_view/index_data_visualizer_view.tsx`
  function clearFiltersOnLeave() {
    return () => {
      // We want to clear all filters that have not been pinned globally
      // when navigating to other pages
      dataService.query.filterManager.getFilters().filter(f => {
        var _f$$state;
        return ((_f$$state = f.$state) === null || _f$$state === void 0 ? void 0 : _f$$state.store) === _esQuery.FilterStateStore.APP_STATE;
      }).forEach(f => dataService.query.filterManager.removeFilter(f));
    };
  }, [dataService.query.filterManager]);
  (0, _react.useEffect)(() => {
    if ((globalState === null || globalState === void 0 ? void 0 : globalState.time) !== undefined) {
      if (!(0, _lodash.isEqual)({
        from: globalState.time.from,
        to: globalState.time.to
      }, timefilter.getTime())) {
        timefilter.setTime({
          from: globalState.time.from,
          to: globalState.time.to
        });
      }
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(globalState === null || globalState === void 0 ? void 0 : globalState.time), timefilter]);
  (0, _react.useEffect)(() => {
    if ((globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval) !== undefined) {
      timefilter.setRefreshInterval(globalState.refreshInterval);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval), timefilter]);
  (0, _react.useEffect)(() => {
    // Update data query manager if input string is updated
    dataService === null || dataService === void 0 ? void 0 : dataService.query.queryString.setQuery({
      query: searchString !== null && searchString !== void 0 ? searchString : '',
      language: searchQueryLanguage
    });
  }, [dataService, searchQueryLanguage, searchString]);
  (0, _react.useEffect)(() => {
    dispatch((0, _state.setInitialAnalysisStart)((0, _log_rate_analysis.appStateToWindowParameters)(stateFromUrl.wp)));
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const onWindowParametersHandler = (wp, replace = false) => {
    if (!(0, _lodash.isEqual)((0, _log_rate_analysis.windowParametersToAppState)(wp), stateFromUrl.wp)) {
      setUrlState({
        wp: (0, _log_rate_analysis.windowParametersToAppState)(wp)
      }, replace);
    }
  };
  const onAnalysisCompleted = analysisResults => {
    var _analysisResults$sign;
    const significantFieldValues = (0, _lodash.orderBy)(analysisResults === null || analysisResults === void 0 ? void 0 : (_analysisResults$sign = analysisResults.significantItems) === null || _analysisResults$sign === void 0 ? void 0 : _analysisResults$sign.map(item => ({
      field: item.fieldName,
      value: item.fieldValue,
      docCount: item.doc_count,
      pValue: item.pValue
    })), ['pValue', 'docCount'], ['asc', 'asc']).slice(0, 50);
    const logRateAnalysisType = analysisResults === null || analysisResults === void 0 ? void 0 : analysisResults.analysisType;
    setLogRateAnalysisParams(significantFieldValues && logRateAnalysisType ? {
      logRateAnalysisType,
      significantFieldValues
    } : undefined);
  };
  const messages = (0, _react.useMemo)(() => {
    var _logRateAnalysisParam;
    const hasLogRateAnalysisParams = logRateAnalysisParams && ((_logRateAnalysisParam = logRateAnalysisParams.significantFieldValues) === null || _logRateAnalysisParam === void 0 ? void 0 : _logRateAnalysisParam.length) > 0;
    if (!hasLogRateAnalysisParams || !observabilityAIAssistant) {
      return undefined;
    }
    const {
      logRateAnalysisType
    } = logRateAnalysisParams;
    const header = 'Field name,Field value,Doc count,p-value';
    const rows = logRateAnalysisParams.significantFieldValues.map(item => Object.values(item).join(',')).join('\n');
    return observabilityAIAssistant.getContextualInsightMessages({
      message: 'Can you identify possible causes and remediations for these log rate analysis results',
      instructions: `You are an AIOps expert using Elastic's Kibana on call being consulted about a log rate change that got triggered by a ${logRateAnalysisType} in log messages. Your job is to take immediate action and proceed with both urgency and precision.
      "Log Rate Analysis" is an AIOps feature that uses advanced statistical methods to identify reasons for increases and decreases in log rates. It makes it easy to find and investigate causes of unusual spikes or dips by using the analysis workflow view.
      You are using "Log Rate Analysis" and ran the statistical analysis on the log messages which occured during the alert.
      You received the following analysis results from "Log Rate Analysis" which list statistically significant co-occuring field/value combinations sorted from most significant (lower p-values) to least significant (higher p-values) that ${logRateAnalysisType === _log_rate_analysis_type.LOG_RATE_ANALYSIS_TYPE.SPIKE ? 'contribute to the log rate spike' : 'are less or not present in the log rate dip'}:

      ${logRateAnalysisType === _log_rate_analysis_type.LOG_RATE_ANALYSIS_TYPE.SPIKE ? 'The median log rate in the selected deviation time range is higher than the baseline. Therefore, the results shows statistically significant items within the deviation time range that are contributors to the spike. The "doc count" column refers to the amount of documents in the deviation time range.' : 'The median log rate in the selected deviation time range is lower than the baseline. Therefore, the analysis results table shows statistically significant items within the baseline time range that are less in number or missing within the deviation time range. The "doc count" column refers to the amount of documents in the baseline time range.'}

      ${header}
      ${rows}

      Based on the above analysis results and your observability expert knowledge, output the following:
      Analyse the type of these logs and explain their usual purpose (1 paragraph).
      ${logRateAnalysisType === _log_rate_analysis_type.LOG_RATE_ANALYSIS_TYPE.SPIKE ? 'Based on the type of these logs do a root cause analysis on why the field and value combinations from the analysis results are causing this log rate spike (2 parapraphs)' : 'Based on the type of these logs explain why the statistically significant field and value combinations are less in number or missing from the log rate dip with concrete examples based on the analysis results data which contains items that are present in the baseline time range and are missing or less in number in the deviation time range (2 paragraphs)'}.
      ${logRateAnalysisType === _log_rate_analysis_type.LOG_RATE_ANALYSIS_TYPE.SPIKE ? 'Recommend concrete remediations to resolve the root cause (3 bullet points).' : ''}

      Do not mention individual p-values from the analysis results.
      Do not repeat the full list of field names and field values back to the user.
      Do not repeat the given instructions in your output.`
    });
  }, [logRateAnalysisParams, observabilityAIAssistant]);
  const logRateAnalysisTitle = _i18n.i18n.translate('xpack.aiops.observabilityAIAssistantContextualInsight.logRateAnalysisTitle', {
    defaultMessage: 'Possible causes and remediations'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    "data-test-subj": "aiopsLogRateAnalysisPage",
    paddingSize: "none",
    panelled: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_page_header.PageHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_search_panel.SearchPanel, {
    searchString: searchString !== null && searchString !== void 0 ? searchString : '',
    searchQuery: searchQuery,
    searchQueryLanguage: searchQueryLanguage,
    setSearchParams: setSearchParams,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_log_rate_analysis_content.LogRateAnalysisContent, {
    esSearchQuery: searchQuery,
    onWindowParametersChange: onWindowParametersHandler,
    onAnalysisCompleted: onAnalysisCompleted,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 13
    }
  })), showContextualInsights && observabilityAIAssistant !== null && observabilityAIAssistant !== void 0 && observabilityAIAssistant.ObservabilityAIAssistantContextualInsight && messages ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(observabilityAIAssistant.ObservabilityAIAssistantContextualInsight, {
    title: logRateAnalysisTitle,
    messages: messages,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 15
    }
  })) : null)));
};
exports.LogRateAnalysisPage = LogRateAnalysisPage;