"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaxSeriesControl = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlAggUtils = require("@kbn/ml-agg-utils");
var _const = require("../../embeddables/change_point_chart/const");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/change_point_detection/max_series_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const maxSeriesValidator = (0, _mlAggUtils.numberValidator)({
  min: 1,
  max: _const.MAX_SERIES,
  integerOnly: true
});
const MaxSeriesControl = ({
  value,
  onChange,
  onValidationChange,
  disabled,
  inline = true
}) => {
  const maxSeriesValidationResult = maxSeriesValidator(value);
  const maxSeriesInvalid = maxSeriesValidationResult !== null;
  const label = _i18n.i18n.translate('xpack.aiops.changePointDetection.maxSeriesToPlotLabel', {
    defaultMessage: 'Max series'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: maxSeriesInvalid,
    error: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.changePointDetection.maxSeriesToPlotError",
      defaultMessage: "Max series value must be between {minValue} and {maxValue}",
      values: {
        minValue: 1,
        maxValue: _const.MAX_SERIES
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 9
      }
    }),
    label: inline ? undefined : label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "aiopsMaxSeriesControlFieldNumber",
    disabled: disabled,
    prepend: inline ? label : undefined,
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.aiops.changePointDetection.maxSeriesToPlotDescription', {
        defaultMessage: 'The maximum number of change points to visualize.'
      }),
      type: "question",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 11
      }
    }),
    compressed: true,
    fullWidth: true,
    isInvalid: maxSeriesInvalid,
    value: value,
    onChange: e => {
      const newValue = Number(e.target.value);
      onChange(newValue);
      if (onValidationChange) {
        onValidationChange(maxSeriesValidator(newValue));
      }
    },
    min: 1,
    max: _const.MAX_SERIES,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }));
};
exports.MaxSeriesControl = MaxSeriesControl;