"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.throwErrorWhenUnexpectedBindingsAmountFound = throwErrorWhenUnexpectedBindingsAmountFound;
const common_1 = require("@inversifyjs/common");
const stringifyBinding_1 = require("../../binding/calculations/stringifyBinding");
const InversifyCoreError_1 = require("../../error/models/InversifyCoreError");
const InversifyCoreErrorKind_1 = require("../../error/models/InversifyCoreErrorKind");
function throwErrorWhenUnexpectedBindingsAmountFound(bindingNodes, isOptional, bindingConstraintNode, serviceRedirections) {
    const serviceIdentifier = bindingConstraintNode.elem.serviceIdentifier;
    const parentServiceIdentifier = bindingConstraintNode.previous?.elem.serviceIdentifier;
    if (Array.isArray(bindingNodes)) {
        throwErrorWhenMultipleUnexpectedBindingsAmountFound(bindingNodes, isOptional, serviceIdentifier, parentServiceIdentifier, bindingConstraintNode.elem, serviceRedirections);
    }
    else {
        throwErrorWhenSingleUnexpectedBindingFound(bindingNodes, isOptional, serviceIdentifier, parentServiceIdentifier, bindingConstraintNode.elem, serviceRedirections);
    }
}
function throwBindingNotFoundError(serviceIdentifier, parentServiceIdentifier, bindingConstraints, serviceRedirections) {
    const lastResolvedServiceIdentifier = serviceRedirections[serviceRedirections.length - 1] ?? serviceIdentifier;
    const errorMessage = `No bindings found for service: "${(0, common_1.stringifyServiceIdentifier)(lastResolvedServiceIdentifier)}".

Trying to resolve bindings for "${stringifyParentServiceIdentifier(serviceIdentifier, parentServiceIdentifier)}".${stringifyServiceRedirections(serviceRedirections)}${stringifyBindingConstraints(bindingConstraints)}`;
    throw new InversifyCoreError_1.InversifyCoreError(InversifyCoreErrorKind_1.InversifyCoreErrorKind.planning, errorMessage);
}
function throwErrorWhenMultipleUnexpectedBindingsAmountFound(bindingNodes, isOptional, serviceIdentifier, parentServiceIdentifier, bindingConstraints, serviceRedirections) {
    if (bindingNodes.length === 0) {
        if (!isOptional) {
            throwBindingNotFoundError(serviceIdentifier, parentServiceIdentifier, bindingConstraints, serviceRedirections);
        }
    }
    else {
        const lastResolvedServiceIdentifier = serviceRedirections[serviceRedirections.length - 1] ?? serviceIdentifier;
        const errorMessage = `Ambiguous bindings found for service: "${(0, common_1.stringifyServiceIdentifier)(lastResolvedServiceIdentifier)}".${stringifyServiceRedirections(serviceRedirections)}

Registered bindings:

${bindingNodes.map((bindingNode) => (0, stringifyBinding_1.stringifyBinding)(bindingNode.binding)).join('\n')}

Trying to resolve bindings for "${stringifyParentServiceIdentifier(serviceIdentifier, parentServiceIdentifier)}".${stringifyBindingConstraints(bindingConstraints)}`;
        throw new InversifyCoreError_1.InversifyCoreError(InversifyCoreErrorKind_1.InversifyCoreErrorKind.planning, errorMessage);
    }
}
function throwErrorWhenSingleUnexpectedBindingFound(bindingNode, isOptional, serviceIdentifier, parentServiceIdentifier, bindingConstraints, serviceRedirections) {
    if (bindingNode === undefined && !isOptional) {
        throwBindingNotFoundError(serviceIdentifier, parentServiceIdentifier, bindingConstraints, serviceRedirections);
    }
}
function stringifyParentServiceIdentifier(serviceIdentifier, parentServiceIdentifier) {
    return parentServiceIdentifier === undefined
        ? `${(0, common_1.stringifyServiceIdentifier)(serviceIdentifier)} (Root service)`
        : (0, common_1.stringifyServiceIdentifier)(parentServiceIdentifier);
}
function stringifyBindingConstraints(bindingConstraints) {
    const stringifiedTags = bindingConstraints.tags.size === 0
        ? ''
        : `
- tags:
  - ${[...bindingConstraints.tags.keys()].map((key) => key.toString()).join('\n  - ')}`;
    return `

Binding constraints:
- service identifier: ${(0, common_1.stringifyServiceIdentifier)(bindingConstraints.serviceIdentifier)}
- name: ${bindingConstraints.name?.toString() ?? '-'}${stringifiedTags}`;
}
function stringifyServiceRedirections(serviceRedirections) {
    return serviceRedirections.length === 0
        ? ''
        : `

- service redirections:
  - ${serviceRedirections
            .map((serviceIdentifier) => (0, common_1.stringifyServiceIdentifier)(serviceIdentifier))
            .join('\n  - ')}`;
}
//# sourceMappingURL=throwErrorWhenUnexpectedBindingsAmountFound.js.map