"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildClassElementMetadataFromMaybeClassElementMetadata = buildClassElementMetadataFromMaybeClassElementMetadata;
const InversifyCoreError_1 = require("../../error/models/InversifyCoreError");
const InversifyCoreErrorKind_1 = require("../../error/models/InversifyCoreErrorKind");
const ClassElementMetadataKind_1 = require("../models/ClassElementMetadataKind");
function buildClassElementMetadataFromMaybeClassElementMetadata(buildDefaultMetadata, buildMetadataFromMaybeManagedMetadata) {
    return (...params) => (metadata) => {
        if (metadata === undefined) {
            return buildDefaultMetadata(...params);
        }
        if (metadata.kind === ClassElementMetadataKind_1.ClassElementMetadataKind.unmanaged) {
            throw new InversifyCoreError_1.InversifyCoreError(InversifyCoreErrorKind_1.InversifyCoreErrorKind.injectionDecoratorConflict, 'Unexpected injection found. Multiple @inject, @multiInject or @unmanaged decorators found');
        }
        return buildMetadataFromMaybeManagedMetadata(metadata, ...params);
    };
}
//# sourceMappingURL=buildClassElementMetadataFromMaybeClassElementMetadata.js.map