"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFlyoutChildProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../services");
var _flyout_context = require("./flyout_context");
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * An intermediate component between EuiFlyout and EuiFlyoutChild.
 * It is responsible for managing the state of the child flyout, and passing it to EuiFlyoutContext.
 * It removes the responsibility of managing child flyout state from EuiFlyout, which is especially important there might not be a child flyout.
 */
var EuiFlyoutChildProvider = exports.EuiFlyoutChildProvider = function EuiFlyoutChildProvider(_ref) {
  var parentSize = _ref.parentSize,
    parentFlyoutRef = _ref.parentFlyoutRef,
    childElement = _ref.childElement,
    childrenToRender = _ref.childrenToRender,
    reportIsChildOpen = _ref.reportIsChildOpen,
    reportChildLayoutMode = _ref.reportChildLayoutMode;
  var _useEuiTheme = (0, _services.useEuiTheme)(),
    euiTheme = _useEuiTheme.euiTheme;
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isChildFlyoutOpen = _useState2[0],
    setIsChildFlyoutOpen = _useState2[1];
  var _useState3 = (0, _react.useState)(typeof window !== 'undefined' ? window.innerWidth : Infinity),
    _useState4 = _slicedToArray(_useState3, 2),
    windowWidth = _useState4[0],
    setWindowWidth = _useState4[1];
  var _useState5 = (0, _react.useState)('side-by-side'),
    _useState6 = _slicedToArray(_useState5, 2),
    childLayoutMode = _useState6[0],
    setChildLayoutMode = _useState6[1];

  // update windowWidth on resize
  (0, _react.useEffect)(function () {
    if (typeof window === 'undefined') return;
    var handleResize = function handleResize() {
      setWindowWidth(window.innerWidth);
    };
    window.addEventListener('resize', handleResize);
    handleResize();
    return function () {
      window.removeEventListener('resize', handleResize);
      reportIsChildOpen === null || reportIsChildOpen === void 0 || reportIsChildOpen(false);
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  // Calculate stacking breakpoint value for child flyout.
  // Stacking breakpoint value is a sum of parent breakpoint value and child breakpoint value.
  var stackingBreakpointValue = (0, _react.useMemo)(function () {
    var parentSizeName = parentSize;
    var childSizeName = childElement.props.size || 's';
    var parentNumericValue = 0;
    if (parentSizeName === 's') parentNumericValue = euiTheme.breakpoint.s;else if (parentSizeName === 'm') parentNumericValue = euiTheme.breakpoint.m;
    // Parent 'l' size is not allowed when child is present, so no need to check here

    var childNumericValue = 0;
    if (childSizeName === 's') childNumericValue = euiTheme.breakpoint.s;else if (childSizeName === 'm') childNumericValue = euiTheme.breakpoint.m;
    return parentNumericValue + childNumericValue;
  }, [parentSize, childElement.props.size, euiTheme.breakpoint]);

  // update childLayoutMode based on windowWidth and the calculated stackingBreakpoint
  (0, _react.useEffect)(function () {
    if (windowWidth >= stackingBreakpointValue) {
      setChildLayoutMode('side-by-side');
    } else {
      setChildLayoutMode('stacked');
    }
  }, [windowWidth, stackingBreakpointValue]);

  // report isChildFlyoutOpen changes to the parent EuiFlyout
  (0, _react.useEffect)(function () {
    reportIsChildOpen(isChildFlyoutOpen);
  }, [isChildFlyoutOpen, reportIsChildOpen]);

  // report childLayoutMode changes to the parent EuiFlyout
  (0, _react.useEffect)(function () {
    reportChildLayoutMode(childLayoutMode);
  }, [childLayoutMode, reportChildLayoutMode]);
  var contextValue = (0, _react.useMemo)(function () {
    return {
      parentSize: parentSize,
      parentFlyoutRef: parentFlyoutRef,
      isChildFlyoutOpen: isChildFlyoutOpen,
      setIsChildFlyoutOpen: setIsChildFlyoutOpen,
      childLayoutMode: childLayoutMode
    };
  }, [parentSize, parentFlyoutRef, isChildFlyoutOpen, setIsChildFlyoutOpen, childLayoutMode]);
  return (0, _react2.jsx)(_flyout_context.EuiFlyoutContext.Provider, {
    value: contextValue
  }, childrenToRender);
};
EuiFlyoutChildProvider.propTypes = {
  parentSize: _propTypes.default.oneOf(["s", "m"]).isRequired,
  parentFlyoutRef: _propTypes.default.any.isRequired,
  childElement: _propTypes.default.element.isRequired,
  childrenToRender: _propTypes.default.node.isRequired,
  reportIsChildOpen: _propTypes.default.func.isRequired,
  reportChildLayoutMode: _propTypes.default.func.isRequired
};