"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointPackageCustomExtension = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _user_privileges = require("../../../../../../common/components/user_privileges");
var _no_privileges = require("../../../../../../common/components/no_privileges");
var _use_can_access_some_artifacts = require("../hooks/use_can_access_some_artifacts");
var _kibana = require("../../../../../../common/lib/kibana");
var _api_client = require("../../../../trusted_apps/service/api_client");
var _api_client2 = require("../../../../event_filters/service/api_client");
var _host_isolation_exceptions_api_client = require("../../../../host_isolation_exceptions/host_isolation_exceptions_api_client");
var _services = require("../../../../blocklist/services");
var _fleet_artifacts_card = require("./components/fleet_artifacts_card");
var _routing = require("../../../../../common/routing");
var _translations = require("./translations");
var _use_license = require("../../../../../../common/hooks/use_license");
var _api_client3 = require("../../../../trusted_devices/service/api_client");
var _use_experimental_features = require("../../../../../../common/hooks/use_experimental_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/ingest_manager_integration/endpoint_package_custom_extension/endpoint_package_custom_extension.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TrustedAppsArtifactCard = /*#__PURE__*/(0, _react.memo)(props => {
  const http = (0, _kibana.useHttp)();
  const trustedAppsApiClientInstance = (0, _react.useMemo)(() => _api_client.TrustedAppsApiClient.getInstance(http), [http]);
  return /*#__PURE__*/_react.default.createElement(_fleet_artifacts_card.FleetArtifactsCard, (0, _extends2.default)({}, props, {
    artifactApiClientInstance: trustedAppsApiClientInstance,
    getArtifactsPath: _routing.getTrustedAppsListPath,
    labels: _translations.TRUSTED_APPS_LABELS,
    "data-test-subj": "trustedApps",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }));
});
TrustedAppsArtifactCard.displayName = 'TrustedAppsArtifactCard';
const TrustedDevicesArtifactCard = /*#__PURE__*/(0, _react.memo)(props => {
  const http = (0, _kibana.useHttp)();
  const trustedDevicesApiClientInstance = (0, _react.useMemo)(() => _api_client3.TrustedDevicesApiClient.getInstance(http), [http]);
  return /*#__PURE__*/_react.default.createElement(_fleet_artifacts_card.FleetArtifactsCard, (0, _extends2.default)({}, props, {
    artifactApiClientInstance: trustedDevicesApiClientInstance,
    getArtifactsPath: _routing.getTrustedDevicesListPath,
    labels: _translations.TRUSTED_DEVICES_LABELS,
    "data-test-subj": "trustedDevices",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }));
});
TrustedDevicesArtifactCard.displayName = 'TrustedDevicesArtifactCard';
const EventFiltersArtifactCard = /*#__PURE__*/(0, _react.memo)(props => {
  const http = (0, _kibana.useHttp)();
  const eventFiltersApiClientInstance = (0, _react.useMemo)(() => _api_client2.EventFiltersApiClient.getInstance(http), [http]);
  return /*#__PURE__*/_react.default.createElement(_fleet_artifacts_card.FleetArtifactsCard, (0, _extends2.default)({}, props, {
    artifactApiClientInstance: eventFiltersApiClientInstance,
    getArtifactsPath: _routing.getEventFiltersListPath,
    labels: _translations.EVENT_FILTERS_LABELS,
    "data-test-subj": "eventFilters",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }));
});
EventFiltersArtifactCard.displayName = 'EventFiltersArtifactCard';
const HostIsolationExceptionsArtifactCard = /*#__PURE__*/(0, _react.memo)(props => {
  const http = (0, _kibana.useHttp)();
  const hostIsolationExceptionsApiClientInstance = (0, _react.useMemo)(() => _host_isolation_exceptions_api_client.HostIsolationExceptionsApiClient.getInstance(http), [http]);
  return /*#__PURE__*/_react.default.createElement(_fleet_artifacts_card.FleetArtifactsCard, (0, _extends2.default)({}, props, {
    artifactApiClientInstance: hostIsolationExceptionsApiClientInstance,
    getArtifactsPath: _routing.getHostIsolationExceptionsListPath,
    labels: _translations.HOST_ISOLATION_EXCEPTIONS_LABELS,
    "data-test-subj": "hostIsolationExceptions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 5
    }
  }));
});
HostIsolationExceptionsArtifactCard.displayName = 'HostIsolationExceptionsArtifactCard';
const BlockListArtifactCard = /*#__PURE__*/(0, _react.memo)(props => {
  const http = (0, _kibana.useHttp)();
  const blocklistsApiClientInstance = (0, _react.useMemo)(() => _services.BlocklistsApiClient.getInstance(http), [http]);
  return /*#__PURE__*/_react.default.createElement(_fleet_artifacts_card.FleetArtifactsCard, (0, _extends2.default)({}, props, {
    artifactApiClientInstance: blocklistsApiClientInstance,
    getArtifactsPath: _routing.getBlocklistsListPath,
    labels: _translations.BLOCKLISTS_LABELS,
    "data-test-subj": "blocklists",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 5
    }
  }));
});
BlockListArtifactCard.displayName = 'BlockListArtifactCard';

/**
 * The UI displayed in Fleet's Endpoint integration page, under the `Advanced` tab
 */
const EndpointPackageCustomExtension = exports.EndpointPackageCustomExtension = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    loading,
    canReadBlocklist,
    canReadEventFilters,
    canReadTrustedApplications,
    canReadHostIsolationExceptions,
    canReadTrustedDevices
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const userCanAccessContent = (0, _use_can_access_some_artifacts.useCanAccessSomeArtifacts)();
  const isEnterprise = (0, _use_license.useLicense)().isEnterprise();
  const trustedDevicesVisible = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('trustedDevices') && canReadTrustedDevices && isEnterprise;
  const artifactCards = (0, _react.useMemo)(() => {
    if (loading) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
    }
    if (!userCanAccessContent) {
      return /*#__PURE__*/_react.default.createElement(_no_privileges.NoPrivileges, {
        docLinkSelector: links => links.securitySolution.privileges,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 158,
          columnNumber: 16
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "fleetEndpointPackageCustomContent",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 9
      }
    }, canReadTrustedApplications && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(TrustedAppsArtifactCard, (0, _extends2.default)({}, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 15
      }
    })), trustedDevicesVisible && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(TrustedDevicesArtifactCard, (0, _extends2.default)({}, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 15
      }
    })), canReadEventFilters && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EventFiltersArtifactCard, (0, _extends2.default)({}, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 15
      }
    })), canReadHostIsolationExceptions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(HostIsolationExceptionsArtifactCard, (0, _extends2.default)({}, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 15
      }
    })), canReadBlocklist && /*#__PURE__*/_react.default.createElement(BlockListArtifactCard, (0, _extends2.default)({}, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 32
      }
    })));
  }, [loading, userCanAccessContent, canReadTrustedApplications, props, trustedDevicesVisible, canReadEventFilters, canReadHostIsolationExceptions, canReadBlocklist]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: 'spaceAround',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 209,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l",
      "data-test-subj": "endpointExtensionLoadingSpinner",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 13
      }
    })));
  }
  return artifactCards;
});
EndpointPackageCustomExtension.displayName = 'EndpointPackageCustomExtension';