"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointIsolationFlyoutPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _validators = require("../../../../../../common/utils/validators");
var _host_isolation = require("../../../../../../common/components/endpoint/host_isolation");
var _routing = require("../../../../../common/routing");
var _hooks = require("../../hooks");
var _selectors = require("../../../store/selectors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/endpoint_hosts/view/details/components/endpoint_isolate_flyout_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Component handles both isolate and un-isolate for a given endpoint
 */
const EndpointIsolationFlyoutPanel = exports.EndpointIsolationFlyoutPanel = /*#__PURE__*/(0, _react.memo)(({
  hostMeta
}) => {
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    show,
    ...queryParams
  } = (0, _hooks.useEndpointSelector)(_selectors.uiQueryParams);
  const isCurrentlyIsolated = (0, _validators.isEndpointHostIsolated)(hostMeta);
  const isPending = (0, _hooks.useEndpointSelector)(_selectors.getIsIsolationRequestPending);
  const wasSuccessful = (0, _hooks.useEndpointSelector)(_selectors.getWasIsolationRequestSuccessful);
  const isolateError = (0, _hooks.useEndpointSelector)(_selectors.getIsolationRequestError);
  const [formValues, setFormValues] = (0, _react.useState)({
    comment: ''
  });
  const IsolationForm = isCurrentlyIsolated ? _host_isolation.EndpointUnisolateForm : _host_isolation.EndpointIsolateForm;
  const handleCancel = (0, _react.useCallback)(() => {
    history.push((0, _routing.getEndpointDetailsPath)({
      name: 'endpointDetails',
      ...queryParams,
      selected_endpoint: hostMeta.agent.id
    }));
  }, [history, hostMeta.agent.id, queryParams]);
  const handleConfirm = (0, _react.useCallback)(() => {
    dispatch({
      type: 'endpointIsolationRequest',
      payload: {
        type: isCurrentlyIsolated ? 'unisolate' : 'isolate',
        data: {
          endpoint_ids: [hostMeta.agent.id],
          comment: formValues.comment
        }
      }
    });
  }, [dispatch, formValues.comment, hostMeta.agent.id, isCurrentlyIsolated]);
  const handleChange = (0, _react.useCallback)(changes => {
    setFormValues(prevState => {
      return {
        ...prevState,
        ...changes
      };
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, wasSuccessful && /*#__PURE__*/_react.default.createElement(_host_isolation.EndpointIsolateSuccess, {
    hostName: hostMeta.host.name,
    isolateAction: isCurrentlyIsolated ? 'unisolateHost' : 'isolateHost',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, wasSuccessful ? /*#__PURE__*/_react.default.createElement(_host_isolation.ActionCompletionReturnButton, {
    onClick: handleCancel,
    buttonText: _i18n.i18n.translate('xpack.securitySolution.endpoint.hostIsolation.successProceedButton', {
      defaultMessage: 'Return to endpoint details'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    isInvalid: !!isolateError,
    error: isolateError === null || isolateError === void 0 ? void 0 : isolateError.message,
    "data-test-subj": "endpointIsolationForm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(IsolationForm, {
    comment: formValues.comment,
    isLoading: isPending,
    hostName: hostMeta.host.name,
    onCancel: handleCancel,
    onConfirm: handleConfirm,
    onChange: handleChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }))));
});
EndpointIsolationFlyoutPanel.displayName = 'EndpointIsolateFlyoutPanel';