"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagedUserTable = exports.ManagedUser = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _css = require("@emotion/css");
var _model = require("../../../../explore/users/store/model");
var _managed_details = require("../../../../../common/search_strategy/security_solution/users/managed_details");
var i18n = _interopRequireWildcard(require("../translations"));
var _basic_table = require("../../../../common/components/ml/tables/basic_table");
var _columns = require("../utils/columns");
var _constants = require("../constants");
var _constants2 = require("../../shared/constants");
var _inspect = require("../../../../common/components/inspect");
var _kibana = require("../../../../common/lib/kibana");
var _managed_user_accordion = require("./managed_user_accordion");
var _use_managed_user_items = require("../hooks/use_managed_user_items");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/user_right/components/managed_user.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const accordionStyle = (0, _css.css)`
  width: 100%;
`;
const ManagedUser = ({
  managedUser,
  contextID,
  openDetailsPanel,
  isPreviewMode,
  isLinkEnabled
}) => {
  var _managedUser$data, _managedUser$data2;
  const entraManagedUser = (_managedUser$data = managedUser.data) === null || _managedUser$data === void 0 ? void 0 : _managedUser$data[_managed_details.ManagedUserDatasetKey.ENTRA];
  const oktaManagedUser = (_managedUser$data2 = managedUser.data) === null || _managedUser$data2 === void 0 ? void 0 : _managedUser$data2[_managed_details.ManagedUserDatasetKey.OKTA];
  const {
    getAppUrl
  } = (0, _kibana.useAppUrl)();
  const installedIntegrationHref = (0, _react.useMemo)(() => getAppUrl({
    appId: 'integrations',
    path: _constants.INSTALL_EA_INTEGRATIONS_HREF
  }), [getAppUrl]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    isLoading: managedUser.isLoading,
    initialIsOpen: true,
    id: 'managedUser-data',
    "data-test-subj": "managedUser-data",
    buttonProps: {
      'data-test-subj': 'managedUser-accordion-button'
    },
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 15
      }
    }, i18n.MANAGED_DATA_TITLE)),
    extraAction: /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
      queryId: _constants2.MANAGED_USER_QUERY_ID,
      title: i18n.MANAGED_USER_INSPECT_TITLE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 13
      }
    }),
    className: accordionStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.timeline.userDetails.managed.description",
    defaultMessage: "Metadata from any asset repository integrations enabled in your environment.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }), !managedUser.isLoading && !managedUser.isIntegrationEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "managedUser-integration-disable-callout",
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 24
      }
    }, i18n.NO_ACTIVE_INTEGRATION_TITLE),
    titleSize: "s",
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 23
      }
    }, i18n.NO_ACTIVE_INTEGRATION_TEXT),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      href: installedIntegrationHref,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 19
      }
    }, i18n.ADD_EXTERNAL_INTEGRATION_BUTTON),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 15
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !entraManagedUser && !oktaManagedUser && !managedUser.isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "managedUser-no-data",
    title: i18n.NO_MANAGED_DATA_TITLE,
    color: "warning",
    iconType: "question",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 19
    }
  }, i18n.NO_MANAGED_DATA_TEXT)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, entraManagedUser && entraManagedUser.fields && /*#__PURE__*/_react.default.createElement(_managed_user_accordion.ManagedUserAccordion, {
    title: i18n.ENTRA_DATA_PANEL_TITLE,
    managedUser: entraManagedUser.fields,
    tableType: _model.UserAssetTableType.assetEntra,
    openDetailsPanel: openDetailsPanel,
    isLinkEnabled: isLinkEnabled,
    isPreviewMode: isPreviewMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(ManagedUserTable, {
    contextID: contextID,
    managedUser: entraManagedUser.fields,
    tableType: _model.UserAssetTableType.assetEntra,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 23
    }
  })), entraManagedUser && oktaManagedUser && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 59
    }
  }), oktaManagedUser && oktaManagedUser.fields && /*#__PURE__*/_react.default.createElement(_managed_user_accordion.ManagedUserAccordion, {
    title: i18n.OKTA_DATA_PANEL_TITLE,
    managedUser: oktaManagedUser.fields,
    tableType: _model.UserAssetTableType.assetOkta,
    openDetailsPanel: openDetailsPanel,
    isLinkEnabled: isLinkEnabled,
    isPreviewMode: isPreviewMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(ManagedUserTable, {
    contextID: contextID,
    managedUser: oktaManagedUser.fields,
    tableType: _model.UserAssetTableType.assetOkta,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 23
    }
  })))))));
};
exports.ManagedUser = ManagedUser;
const ManagedUserTable = ({
  managedUser,
  contextID,
  tableType
}) => {
  const managedUserTableColumns = (0, _react.useMemo)(() => (0, _columns.getManagedUserTableColumns)(contextID), [contextID]);
  const managedItems = (0, _use_managed_user_items.useManagedUserItems)(tableType, managedUser);
  return /*#__PURE__*/_react.default.createElement(_basic_table.BasicTable, {
    "data-test-subj": "managedUser-table",
    columns: managedUserTableColumns,
    items: managedItems !== null && managedItems !== void 0 ? managedItems : [],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 5
    }
  });
};
exports.ManagedUserTable = ManagedUserTable;