"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderDataCards = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../../../../common/entity_analytics/types");
var _use_generic_entity_criticality = require("./hooks/use_generic_entity_criticality");
var _responsive_data_cards = require("./components/responsive_data_cards");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/generic_right/header_data_cards.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HeaderDataCards = ({
  id,
  subType,
  type
}) => {
  var _assignAssetCriticali, _assignAssetCriticali2;
  const {
    assignAssetCriticality
  } = (0, _use_generic_entity_criticality.useGenericEntityCriticality)({
    idField: _types.EntityIdentifierFields.generic,
    idValue: id
  });
  const cards = (0, _react.useMemo)(() => [{
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: 'spaceBetween',
      wrap: false,
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 13
      }
    }, 'ID'), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 15
      }
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: copy,
      iconType: "document",
      color: "text",
      "aria-label": _i18n.i18n.translate('xpack.securitySolution.genericEntityFlyout.flyoutHeader.headerDataBoxes.copyIdAriaLabel', {
        defaultMessage: 'Copy ID'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 19
      }
    })))),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextTruncate, {
      text: id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 22
      }
    })
  }, {
    title: _i18n.i18n.translate('xpack.securitySolution.genericEntityFlyout.flyoutHeader.headerDataBoxes.typeLabel', {
      defaultMessage: 'Type'
    }),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextTruncate, {
      text: type || '',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 22
      }
    })
  }, {
    title: _i18n.i18n.translate('xpack.securitySolution.genericEntityFlyout.flyoutHeader.headerDataBoxes.subtypeLabel', {
      defaultMessage: 'Sub Type'
    }),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextTruncate, {
      text: subType || '',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 22
      }
    })
  }], [id, type, subType]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, assignAssetCriticality.isError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    onDismiss: () => {
      assignAssetCriticality.reset();
    },
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.genericEntityFlyout.flyoutHeader.headerDataBoxes.assignCriticalityErrorTitle",
      defaultMessage: "We could not assign the selected criticality",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 15
      }
    }),
    color: "danger",
    iconType: "error",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }, ((_assignAssetCriticali = assignAssetCriticality.error) === null || _assignAssetCriticali === void 0 ? void 0 : (_assignAssetCriticali2 = _assignAssetCriticali.body) === null || _assignAssetCriticali2 === void 0 ? void 0 : _assignAssetCriticali2.message) || _i18n.i18n.translate('xpack.securitySolution.genericEntityFlyout.flyoutHeader.headerDataBoxes.assignCriticalityErrorText', {
    defaultMessage: 'Something went wrong during validation. Please try again.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_responsive_data_cards.ResponsiveDataCards, {
    cards: cards,
    collapseWidth: 750,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }));
};
exports.HeaderDataCards = HeaderDataCards;