"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandableBadgeGroup = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/generic_right/components/expandable_badge_group.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExpandableBadgeGroup = ({
  badges,
  initialBadgeLimit = 'all',
  maxHeight
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const togglePopover = () => setIsPopoverOpen(prev => !prev);
  const closePopover = () => setIsPopoverOpen(false);
  const visibleBadgesCount = initialBadgeLimit === 'all' ? badges.length : initialBadgeLimit;
  const remainingCount = badges.length - visibleBadgesCount;
  const visibleBadges = (0, _react.useMemo)(() => badges.slice(0, visibleBadgesCount).map((badge, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
    key: `visible-${index}`
  }, badge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 32
    }
  }))), [badges, visibleBadgesCount]);
  const hiddenBadges = (0, _react.useMemo)(() => badges.slice(visibleBadgesCount).map((badge, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
    key: `hidden-${index}`
  }, badge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 32
    }
  }))), [badges, visibleBadgesCount]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, visibleBadges, remainingCount > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      onClick: togglePopover,
      onClickAriaLabel: _i18n.i18n.translate('xpack.securitySolution.expandableBadgeGroup.expandBadgeAriaLabel', {
        defaultMessage: 'Expand Remaining Badges'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 13
      }
    }, `+${remainingCount}`),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "downCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      maxHeight: maxHeight ? `${maxHeight}px` : 'none',
      overflowY: maxHeight ? 'auto' : 'visible'
    },
    css: {
      maxWidth: 700,
      display: 'flex',
      flexWrap: 'wrap',
      gap: '4px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }, hiddenBadges)));
};
exports.ExpandableBadgeGroup = ExpandableBadgeGroup;