"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenericEntityDetailsPanelKey = exports.GenericEntityDetailsPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _left_panel_content = require("../shared/components/left_panel/left_panel_content");
var _left_panel_header = require("../shared/components/left_panel/left_panel_header");
var _use_get_generic_entity = require("../generic_right/hooks/use_get_generic_entity");
var _entity_details_flyout = require("../../../entity_analytics/components/entity_details_flyout");
var _constants = require("../generic_right/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/generic_details_left/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GenericEntityDetailsPanelKey = exports.GenericEntityDetailsPanelKey = 'generic_entity_details';
const useSelectedTab = (params, tabs) => {
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const path = params.path;
  const selectedTabId = (0, _react.useMemo)(() => {
    var _tabs$find$id, _tabs$find;
    const defaultTab = tabs.length > 0 ? tabs[0].id : undefined;
    if (!path) return defaultTab;
    return (_tabs$find$id = (_tabs$find = tabs.find(tab => tab.id === path.tab)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.id) !== null && _tabs$find$id !== void 0 ? _tabs$find$id : defaultTab;
  }, [path, tabs]);
  const setSelectedTabId = tabId => {
    openLeftPanel({
      id: GenericEntityDetailsPanelKey,
      params: {
        ...params,
        path: {
          tab: tabId
        }
      }
    });
  };
  return {
    setSelectedTabId,
    selectedTabId
  };
};
const GenericEntityDetailsPanel = params => {
  var _getGenericEntity$dat;
  const {
    field,
    value,
    hasMisconfigurationFindings,
    hasVulnerabilitiesFindings,
    hasNonClosedAlerts,
    scopeId
  } = params;

  // By passing the entire params object, we maintain the union type constraints that enforce
  // either entityDocId or entityId to be present
  // Destructuring of the params to extract the relevant fields happens internally in useGetGenericEntity
  const {
    getGenericEntity
  } = (0, _use_get_generic_entity.useGetGenericEntity)(params);
  const source = (_getGenericEntity$dat = getGenericEntity.data) === null || _getGenericEntity$dat === void 0 ? void 0 : _getGenericEntity$dat._source;
  const tabs = (0, _react.useMemo)(() => {
    const insightsTab = hasMisconfigurationFindings || hasVulnerabilitiesFindings || hasNonClosedAlerts ? [(0, _entity_details_flyout.getInsightsInputTab)({
      name: value,
      fieldName: field,
      scopeId
    })] : [];
    const fieldsTableTab = (0, _entity_details_flyout.getFieldsTableTab)({
      document: source || {},
      tableStorageKey: _constants.GENERIC_FLYOUT_STORAGE_KEYS.OVERVIEW_FIELDS_TABLE_PINS
    });
    return [fieldsTableTab, ...insightsTab];
  }, [hasMisconfigurationFindings, hasVulnerabilitiesFindings, hasNonClosedAlerts, value, field, scopeId, source]);
  const {
    selectedTabId,
    setSelectedTabId
  } = useSelectedTab(params, tabs);
  if (!selectedTabId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_left_panel_header.LeftPanelHeader, {
    selectedTabId: selectedTabId,
    setSelectedTabId: setSelectedTabId,
    tabs: tabs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_left_panel_content.LeftPanelContent, {
    selectedTabId: selectedTabId,
    tabs: tabs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }));
};
exports.GenericEntityDetailsPanel = GenericEntityDetailsPanel;
GenericEntityDetailsPanel.displayName = 'GenericEntityDetailsPanel';