"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetadataTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/session-view-plugin/public");
var _context = require("../context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/session_view/tabs/metadata_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Tab displayed in the SessionView preview panel, shows metadata related process selected in the SessionView tree.
 */
const MetadataTab = exports.MetadataTab = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    selectedProcess
  } = (0, _context.useSessionViewPanelContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "none",
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.preview.sessionview.metadataContentAriaLabel', {
      defaultMessage: 'Process'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_public.DetailPanelMetadataTab, {
    processHost: selectedProcess === null || selectedProcess === void 0 ? void 0 : selectedProcess.details.host,
    processContainer: selectedProcess === null || selectedProcess === void 0 ? void 0 : selectedProcess.details.container,
    processOrchestrator: selectedProcess === null || selectedProcess === void 0 ? void 0 : selectedProcess.details.orchestrator,
    processCloud: selectedProcess === null || selectedProcess === void 0 ? void 0 : selectedProcess.details.cloud,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }));
});
MetadataTab.displayName = 'MetadataTab';