"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentSeverity = void 0;
var _react = _interopRequireWildcard(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _test_ids = require("./test_ids");
var _cell_actions = require("../../shared/components/cell_actions");
var _risk_color_palette = require("../../../../common/utils/risk_color_palette");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/severity.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isSeverity = x => x === 'low' || x === 'medium' || x === 'high' || x === 'critical';
/**
 * Document details severity displayed in flyout right section header
 */
const DocumentSeverity = exports.DocumentSeverity = /*#__PURE__*/(0, _react.memo)(({
  getFieldsData,
  showCellActions = false
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const severityToColorMap = (0, _risk_color_palette.useRiskSeverityColors)();
  const severity = (0, _react.useMemo)(() => {
    const fieldsData = getFieldsData(_ruleDataUtils.ALERT_SEVERITY);
    if (typeof fieldsData === 'string' && isSeverity(fieldsData)) {
      return fieldsData;
    } else if (Array.isArray(fieldsData) && fieldsData.length > 0 && isSeverity(fieldsData[0])) {
      return fieldsData[0];
    } else {
      return null;
    }
  }, [getFieldsData]);
  const displayValue = (0, _react.useMemo)(() => {
    var _ref;
    return (_ref = severity && (0, _fp.upperFirst)(severity)) !== null && _ref !== void 0 ? _ref : null;
  }, [severity]);
  const color = (0, _react.useMemo)(() => {
    var _ref2;
    return (_ref2 = severity && severityToColorMap[severity]) !== null && _ref2 !== void 0 ? _ref2 : euiTheme.colors.textSubdued;
  }, [severity, euiTheme.colors.textSubdued, severityToColorMap]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, severity && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showCellActions ? /*#__PURE__*/_react.default.createElement(_cell_actions.CellActions, {
    field: _ruleDataUtils.ALERT_SEVERITY,
    value: severity,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: color,
    "data-test-subj": _test_ids.SEVERITY_VALUE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 17
    }
  }, displayValue)) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: color,
    "data-test-subj": _test_ids.SEVERITY_VALUE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 15
    }
  }, displayValue)));
});
DocumentSeverity.displayName = 'DocumentSeverity';