"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNetworkDnsColumns = void 0;
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react = _interopRequireDefault(require("react"));
var _cell_actions = require("../../../../common/components/cell_actions");
var _search_strategy = require("../../../../../common/search_strategy");
var _helpers = require("../../../../common/components/drag_and_drop/helpers");
var _empty_value = require("../../../../common/components/empty_value");
var _formatted_bytes = require("../../../../common/components/formatted_bytes");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/network_dns_table/columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getNetworkDnsColumns = () => [{
  field: `node.${_search_strategy.NetworkDnsFields.dnsName}`,
  name: i18n.REGISTERED_DOMAIN,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  render: dnsName => {
    if (dnsName != null) {
      return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
        key: (0, _helpers.escapeDataProviderId)(`networkDns-table--name-${dnsName}`),
        mode: _cell_actions.CellActionsMode.HOVER_DOWN,
        visibleCellActions: 5,
        showActionTooltips: true,
        triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
        data: {
          value: dnsName,
          field: 'dns.question.registered_domain'
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 43,
          columnNumber: 11
        }
      }, (0, _empty_value.defaultToEmptyTag)(dnsName));
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  }
}, {
  align: 'right',
  field: `node.${_search_strategy.NetworkDnsFields.queryCount}`,
  name: i18n.TOTAL_QUERIES,
  sortable: true,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: queryCount => {
    if (queryCount != null) {
      return (0, _numeral.default)(queryCount).format('0');
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  }
}, {
  align: 'right',
  field: `node.${_search_strategy.NetworkDnsFields.uniqueDomains}`,
  name: i18n.UNIQUE_DOMAINS,
  sortable: true,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: uniqueDomains => {
    if (uniqueDomains != null) {
      return (0, _numeral.default)(uniqueDomains).format('0');
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  }
}, {
  align: 'right',
  field: `node.${_search_strategy.NetworkDnsFields.dnsBytesIn}`,
  name: i18n.DNS_BYTES_IN,
  sortable: true,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: dnsBytesIn => {
    if (dnsBytesIn != null) {
      return /*#__PURE__*/_react.default.createElement(_formatted_bytes.PreferenceFormattedBytes, {
        value: dnsBytesIn,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 16
        }
      });
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  }
}, {
  align: 'right',
  field: `node.${_search_strategy.NetworkDnsFields.dnsBytesOut}`,
  name: i18n.DNS_BYTES_OUT,
  sortable: true,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: dnsBytesOut => {
    if (dnsBytesOut != null) {
      return /*#__PURE__*/_react.default.createElement(_formatted_bytes.PreferenceFormattedBytes, {
        value: dnsBytesOut,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 16
        }
      });
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  }
}];
exports.getNetworkDnsColumns = getNetworkDnsColumns;