"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPrivilegedMonitorUsersJoin = exports.getPrivilegeMonitrUsersJoinNoTimestamp = void 0;
exports.removeInvalidForkBranchesFromESQL = removeInvalidForkBranchesFromESQL;
var _esqlAst = require("@kbn/esql-ast");
var _fp = require("lodash/fp");
var _parser = require("@kbn/esql-ast/src/parser/parser");
var _is = require("@kbn/esql-ast/src/ast/is");
var E = _interopRequireWildcard(require("fp-ts/Either"));
var _utils = require("../../../../../common/entity_analytics/privileged_user_monitoring/utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPrivilegedMonitorUsersJoin = namespace => `| RENAME @timestamp AS event_timestamp
  | LOOKUP JOIN ${(0, _utils.getPrivilegedMonitorUsersIndex)(namespace)} ON user.name
  | RENAME event_timestamp AS @timestamp
  | WHERE user.is_privileged == true`;
exports.getPrivilegedMonitorUsersJoin = getPrivilegedMonitorUsersJoin;
const getPrivilegeMonitrUsersJoinNoTimestamp = namespace => `| LOOKUP JOIN ${(0, _utils.getPrivilegedMonitorUsersIndex)(namespace)} ON user.name
  | WHERE user.is_privileged == true`;

/**
 * Rewrites que query to remove FORK branches that contain columns not available.
 */
exports.getPrivilegeMonitrUsersJoinNoTimestamp = getPrivilegeMonitrUsersJoinNoTimestamp;
function removeInvalidForkBranchesFromESQL(fields, esql) {
  const {
    root
  } = _parser.Parser.parse(esql);
  const forkCommands = _esqlAst.Walker.findAll(root, node => node.name === 'fork');

  // The query has no FORK command, so we can return the original ESQL query
  if (forkCommands.length === 0) {
    return E.right(esql);
  }

  // There is no technical limitation preventing us from having multiple FORK commands in the query,
  // but the current implementation only supports a single FORK command.
  if (forkCommands.length > 1) {
    throw new Error('removeInvalidForkBranchesFromESQL does not support Multiple FORK commands');
  }
  const forkCommand = forkCommands[0];
  const forkArguments = forkCommand === null || forkCommand === void 0 ? void 0 : forkCommand.args;
  if (!forkArguments || forkArguments.length < 2) {
    throw new Error('Invalid ESQL query: FORK command must have at least two arguments');
  }

  // Columns create by the EVAL and RENAME command
  const createdColumns = getAllCreatedColumns(root);
  const isInvalidColumn = node => (0, _esqlAst.isColumn)(node) && !createdColumns.includes(node.name) && !fields[node.name]; // Check if the column was created or exists in the fields map

  const [invalidBranches, validBranches] = (0, _fp.partition)(forkArgument => _esqlAst.Walker.find(forkArgument, isInvalidColumn), forkArguments);

  // When all branches are valid we can return the original ESQL query
  if (invalidBranches.length === 0) {
    return E.right(esql);
  }

  // No valid FORK branches found
  if (validBranches.length === 0) {
    const invalidFields = new Set();
    invalidBranches.forEach(branch => {
      _esqlAst.Walker.findAll(branch, isInvalidColumn).forEach(node => {
        invalidFields.add(node.name);
      });
    });
    return E.left({
      invalidFields: Array.from(invalidFields)
    });
  }

  // When FORK has only one valid branch we need to remove the fork command from query and add the valid branch back to the root
  if (validBranches.length === 1) {
    return E.right(moveForkBranchToToplevel(root, forkCommand, validBranches[0]));
  }

  // Remove the invalid branches
  invalidBranches.forEach(branch => {
    _esqlAst.mutate.generic.commands.args.remove(root, branch);
  });
  return E.right(_esqlAst.BasicPrettyPrinter.multiline(root));
}
function moveForkBranchToToplevel(root, forkCommand, validBranch) {
  // Find where the fork index is to insert the valid branch
  const forkIndex = root.commands.findIndex(cmd => cmd.name === 'fork');
  _esqlAst.mutate.generic.commands.remove(root, forkCommand);
  validBranch.commands.reverse().forEach(command => {
    _esqlAst.mutate.generic.commands.insert(root, command, forkIndex);
  });
  return _esqlAst.BasicPrettyPrinter.multiline(root);
}
function getAllCreatedColumns(root) {
  const evalCommands = _esqlAst.Walker.findAll(root, node => node.name === 'eval');

  // Columns create by the EVAL command
  // Syntax: | EVAL new_column = column
  const evalColumns = evalCommands.map(command => {
    return command.args.map(arg => {
      if ((0, _esqlAst.isFunctionExpression)(arg) && (0, _esqlAst.isColumn)(arg.args[0])) {
        return arg.args[0].name;
      }
      return null;
    });
  }).flat();
  const renameCommands = _esqlAst.Walker.findAll(root, node => node.name === 'rename');

  // Columns create by the RENAME command
  // Syntaxes:
  // 1. | RENAME column AS new_column, column2 AS new_column2
  // 2. | RENAME new_column = column, new_column2 = column2 (9.1+)
  const renamedColumns = renameCommands.map(command => {
    return command.args.map(arg => {
      if ((0, _is.isAsExpression)(arg)) {
        if ((0, _esqlAst.isColumn)(arg.args[1])) {
          return arg.args[1].name;
        }
      }
      if ((0, _is.isFieldExpression)(arg)) {
        if ((0, _esqlAst.isColumn)(arg.args[0])) {
          return arg.args[0].name;
        }
      }
      return null;
    });
  }).flat();

  // Here we get all created columns from EVAL and RENAME commands
  // We don't care where they are located, we just need to know which columns are available in the query
  // If a column is used on a place where it isn't available ESQL will handle the error
  const createdColumns = [...evalColumns, ...renamedColumns].filter(column => column !== null);
  return createdColumns;
}