"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _search_strategy = require("../../../../common/search_strategy");
var _visualization_embeddable = require("../../../common/components/visualization_actions/visualization_embeddable");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _use_space_id = require("../../../common/hooks/use_space_id");
var _helpers = require("../../../explore/hosts/store/helpers");
var _risk_score_donut_chart = require("../risk_score_donut_chart");
var _risk_score_donut = require("../../lens_attributes/risk_score_donut");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_analytics_risk_score/chart_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CHART_HEIGHT = 180;
const ChartContentComponent = ({
  dataExists,
  kpiQueryId,
  riskEntity,
  severityCount,
  timerange,
  selectedSeverity
}) => {
  const isDonutChartEmbeddablesEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('donutChartEmbeddablesEnabled');
  const spaceId = (0, _use_space_id.useSpaceId)();
  const extraOptions = (0, _react.useMemo)(() => ({
    spaceId,
    filters: (0, _helpers.generateSeverityFilter)(selectedSeverity, riskEntity)
  }), [spaceId, selectedSeverity, riskEntity]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isDonutChartEmbeddablesEnabled && spaceId && dataExists && /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    applyGlobalQueriesAndFilters: false,
    donutTextWrapperClassName: "risk-score",
    extraOptions: extraOptions,
    getLensAttributes: _risk_score_donut.getRiskScoreDonutAttributes,
    height: CHART_HEIGHT,
    id: `${kpiQueryId}-donut`,
    isDonut: true,
    label: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.riskScore.chart.totalLabel', {
      defaultMessage: 'Total'
    }),
    stackByField: riskEntity,
    timerange: timerange,
    width: "270px",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }), !isDonutChartEmbeddablesEnabled && /*#__PURE__*/_react.default.createElement(_risk_score_donut_chart.RiskScoreDonutChart, {
    severityCount: severityCount !== null && severityCount !== void 0 ? severityCount : _search_strategy.EMPTY_SEVERITY_COUNT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }));
};
const ChartContent = exports.ChartContent = /*#__PURE__*/_react.default.memo(ChartContentComponent);