"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAnomaliesColumns = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("../../../../common/machine_learning/helpers");
var _total_anomalies = require("./components/total_anomalies");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_analytics_anomalies/columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DarkShadeText = _styled.default.span`
  color: ${({
  theme: {
    euiTheme
  }
}) => euiTheme.colors.darkShade};
`;
const useAnomaliesColumns = (loading, onJobEnabled, recentlyEnabledJobIds) => {
  const columns = (0, _react.useMemo)(() => [{
    field: 'name',
    name: i18n.ANOMALY_NAME,
    truncateText: true,
    mobileOptions: {
      show: true
    },
    'data-test-subj': 'anomalies-table-column-name',
    render: (jobName, {
      count,
      job
    }) => {
      if (count > 0 || job && ((0, _helpers.isJobStarted)(job.jobState, job.datafeedState) || recentlyEnabledJobIds.includes(job.id))) {
        return jobName;
      } else {
        return /*#__PURE__*/_react.default.createElement(DarkShadeText, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 45,
            columnNumber: 20
          }
        }, jobName);
      }
    }
  }, {
    field: 'count',
    sortable: ({
      count,
      job
    }) => {
      if (count > 0) {
        return count;
      }
      if (job && (0, _helpers.isJobStarted)(job.jobState, job.datafeedState)) {
        return 0;
      }
      return -1;
    },
    truncateText: true,
    align: 'right',
    name: i18n.ANOMALY_COUNT,
    mobileOptions: {
      show: true
    },
    width: '15%',
    'data-test-subj': 'anomalies-table-column-count',
    render: (count, {
      entity,
      job
    }) => {
      if (!job) return '';
      return /*#__PURE__*/_react.default.createElement(_total_anomalies.TotalAnomalies, {
        count: count,
        job: job,
        entity: entity,
        loading: loading,
        onJobEnabled: onJobEnabled,
        recentlyEnabledJobIds: recentlyEnabledJobIds,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 13
        }
      });
    }
  }], [loading, onJobEnabled, recentlyEnabledJobIds]);
  return columns;
};
exports.useAnomaliesColumns = useAnomaliesColumns;