"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryResponseAction = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _securitysolutionHookUtils = require("@kbn/securitysolution-hook-utils");
var _keys = require("@kbn/security-solution-features/keys");
var _use_upselling = require("../../../common/hooks/use_upselling");
var _osquery_response_action_form_field = require("./osquery_response_action_form_field");
var _shared_imports = require("../../../shared_imports");
var _kibana = require("../../../common/lib/kibana");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_response_actions/osquery/osquery_response_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const GhostFormField = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
const OsqueryResponseAction = exports.OsqueryResponseAction = /*#__PURE__*/_react.default.memo(props => {
  const {
    osquery,
    application
  } = (0, _kibana.useKibana)().services;
  const isMounted = (0, _securitysolutionHookUtils.useIsMounted)();

  // serverless component that is returned when users do not have Endpoint.Complete tier
  const UpsellingComponent = (0, _use_upselling.useUpsellingComponent)(_keys.ProductFeatureKey.osqueryAutomatedResponseActions);
  if (osquery) {
    var _application$capabili, _application$capabili2, _application$capabili3, _application$capabili4, _application$capabili5, _application$capabili6, _application$capabili7, _application$capabili8;
    const {
      disabled,
      permissionDenied
    } = osquery.fetchInstallationStatus();
    const disabledOsqueryPermission = !(application !== null && application !== void 0 && (_application$capabili = application.capabilities) !== null && _application$capabili !== void 0 && (_application$capabili2 = _application$capabili.osquery) !== null && _application$capabili2 !== void 0 && _application$capabili2.writeLiveQueries || application !== null && application !== void 0 && (_application$capabili3 = application.capabilities) !== null && _application$capabili3 !== void 0 && (_application$capabili4 = _application$capabili3.osquery) !== null && _application$capabili4 !== void 0 && _application$capabili4.runSavedQueries && (application !== null && application !== void 0 && (_application$capabili5 = application.capabilities) !== null && _application$capabili5 !== void 0 && (_application$capabili6 = _application$capabili5.osquery) !== null && _application$capabili6 !== void 0 && _application$capabili6.readSavedQueries || application !== null && application !== void 0 && (_application$capabili7 = application.capabilities) !== null && _application$capabili7 !== void 0 && (_application$capabili8 = _application$capabili7.osquery) !== null && _application$capabili8 !== void 0 && _application$capabili8.readPacks));
    if (UpsellingComponent) {
      return /*#__PURE__*/_react.default.createElement(UpsellingComponent, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 45,
          columnNumber: 14
        }
      });
    }
    if (permissionDenied || disabledOsqueryPermission) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
        path: `${props.item.path}.params`,
        component: GhostFormField,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
        title: /*#__PURE__*/_react.default.createElement("h2", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 53,
            columnNumber: 20
          }
        }, _translations.PERMISSION_DENIED),
        titleSize: "xs",
        iconType: "logoOsquery",
        body: /*#__PURE__*/_react.default.createElement("p", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 57,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.osquery.action.missingPrivileges",
          defaultMessage: "To access this page, ask your administrator for {osquery} Kibana privileges.",
          values: {
            osquery: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 62,
                columnNumber: 30
              }
            }, 'osquery')
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 58,
            columnNumber: 17
          }
        })),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 52,
          columnNumber: 11
        }
      }));
    }
    if (disabled) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
        path: `${props.item.path}.params`,
        component: GhostFormField,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
        iconType: "logoOsquery",
        title: /*#__PURE__*/_react.default.createElement("h2", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 78,
            columnNumber: 20
          }
        }, _translations.SHORT_EMPTY_TITLE),
        titleSize: "xs",
        body: /*#__PURE__*/_react.default.createElement("p", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 80,
            columnNumber: 19
          }
        }, _translations.NOT_AVAILABLE),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 11
        }
      }));
    }
    if (isMounted()) {
      return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
        path: `${props.item.path}.params`,
        component: _osquery_response_action_form_field.ResponseActionFormField,
        readDefaultValueOnForm: !props.item.isNew,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 9
        }
      });
    }
  }
  return null;
});
OsqueryResponseAction.displayName = 'OsqueryResponseAction';