"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatEuiFlexGroup = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _list_tree_icon = _interopRequireDefault(require("./assets/list_tree_icon.svg"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/description_step/threat_description.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const lazyMitreConfiguration = () => {
  /**
   * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
   * See https://webpack.js.org/api/module-methods/#magic-comments
   */
  return Promise.resolve().then(() => _interopRequireWildcard(require(/* webpackChunkName: "lazy_mitre_configuration" */
  '../../../../detections/mitre/mitre_tactics_techniques')));
};
const ThreatEuiFlexGroupStyles = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  .euiFlexItem {
    margin-bottom: 0px;
  }
`;
const SubtechniqueFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin-left: ${({
  theme
}) => theme.eui.euiSizeM};
`;
const TechniqueLinkItem = (0, _styledComponents.default)(_eui.EuiButtonEmpty)`
  .euiIcon {
    width: 8px;
    height: 8px;
  }
  align-self: flex-start;
`;
const ThreatEuiFlexGroup = ({
  threat,
  'data-test-subj': dataTestSubj = 'threat'
}) => {
  const [techniquesOptions, setTechniquesOptions] = (0, _react.useState)([]);
  const [tacticsOptions, setTacticsOptions] = (0, _react.useState)([]);
  const [subtechniquesOptions, setSubtechniquesOptions] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    async function getMitre() {
      const mitreConfig = await lazyMitreConfiguration();
      setSubtechniquesOptions(mitreConfig.subtechniques);
      setTechniquesOptions(mitreConfig.techniques);
      setTacticsOptions(mitreConfig.tactics);
    }
    getMitre();
  }, []);
  return /*#__PURE__*/_react.default.createElement(ThreatEuiFlexGroupStyles, {
    direction: "column",
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, threat.map((singleThreat, index) => {
    const tactic = tacticsOptions.find(t => t.id === singleThreat.tactic.id);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: `${singleThreat.tactic.name}-${index}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "threatTacticLink",
      href: singleThreat.tactic.reference,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 13
      }
    }, tactic != null ? tactic.label : `${singleThreat.tactic.name} (${singleThreat.tactic.id})`), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      alignItems: "flexStart",
      direction: "column",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 13
      }
    }, singleThreat.technique && singleThreat.technique.map((technique, techniqueIndex) => {
      var _myTechnique$id;
      const myTechnique = techniquesOptions.find(t => t.id === technique.id);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: (_myTechnique$id = myTechnique === null || myTechnique === void 0 ? void 0 : myTechnique.id) !== null && _myTechnique$id !== void 0 ? _myTechnique$id : techniqueIndex,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(TechniqueLinkItem, {
        "data-test-subj": "threatTechniqueLink",
        href: technique.reference,
        target: "_blank",
        iconType: _list_tree_icon.default,
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 23
        }
      }, myTechnique != null ? myTechnique.label : `${technique.name} (${technique.id})`), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "none",
        alignItems: "flexStart",
        direction: "column",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 23
        }
      }, technique.subtechnique != null && technique.subtechnique.map((subtechnique, subtechniqueIndex) => {
        var _mySubtechnique$id;
        const mySubtechnique = subtechniquesOptions.find(t => t.id === subtechnique.id);
        return /*#__PURE__*/_react.default.createElement(SubtechniqueFlexItem, {
          key: (_mySubtechnique$id = mySubtechnique === null || mySubtechnique === void 0 ? void 0 : mySubtechnique.id) !== null && _mySubtechnique$id !== void 0 ? _mySubtechnique$id : subtechniqueIndex,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 104,
            columnNumber: 31
          }
        }, /*#__PURE__*/_react.default.createElement(TechniqueLinkItem, {
          "data-test-subj": "threatSubtechniqueLink",
          href: subtechnique.reference,
          target: "_blank",
          iconType: _list_tree_icon.default,
          size: "xs",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 105,
            columnNumber: 33
          }
        }, mySubtechnique != null ? mySubtechnique.label : `${subtechnique.name} (${subtechnique.id})`));
      })));
    })));
  }));
};
exports.ThreatEuiFlexGroup = ThreatEuiFlexGroup;