"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateAutoImportCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _assistant = _interopRequireDefault(require("@kbn/ai-assistant-icon/svg/assistant.svg"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _integration_context = require("./integration_context");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/lib/integrations/hooks/use_create_auto_import_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TITLE = _i18n.i18n.translate('xpack.securitySolution.integrations.createAutoImportCard.title', {
  defaultMessage: 'Custom integration'
});
const DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.integrations.createAutoImportCard.description', {
  defaultMessage: 'AI-driven process to build the integration step-by-step, or upload a pre-made .zip package integration.'
});
const BADGE = _i18n.i18n.translate('xpack.securitySolution.integrations.createAutoImportCard.badge', {
  defaultMessage: 'New'
});
const navigation = {
  appId: 'integrations',
  path: 'create'
};
const ID = 'placeholder:auto_import';
const useCreateAutoImportCard = () => {
  const {
    getAppUrl,
    navigateTo
  } = (0, _securitySolutionNavigation.useNavigation)();
  const {
    reportLinkClick
  } = (0, _integration_context.useIntegrationContext)().telemetry;
  return (0, _react.useCallback)(() => {
    return {
      id: ID,
      title: TITLE,
      name: TITLE,
      titleBadge: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "warning",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 19
        }
      }, BADGE),
      titleLineClamp: _constants.CARD_TITLE_LINE_CLAMP,
      descriptionLineClamp: _constants.CARD_DESCRIPTION_LINE_CLAMP,
      maxCardHeight: _constants.MAX_CARD_HEIGHT_IN_PX,
      description: DESCRIPTION,
      icons: [{
        src: _assistant.default,
        type: 'svg'
      }],
      url: getAppUrl(navigation),
      onCardClick: () => {
        reportLinkClick === null || reportLinkClick === void 0 ? void 0 : reportLinkClick(`${_constants.TELEMETRY_INTEGRATION_CARD}_${ID}`);
        navigateTo(navigation);
      },
      categories: [],
      integration: '',
      version: '0.0.0'
    };
  }, [getAppUrl, navigateTo, reportLinkClick]);
};
exports.useCreateAutoImportCard = useCreateAutoImportCard;