"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDataView = exports.QueryBar = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/unified-search-plugin/public");
var _public3 = require("@kbn/kibana-utils-plugin/public");
var _react2 = require("@emotion/react");
var _kibana = require("../../lib/kibana");
var _convert_to_query_type = require("./convert_to_query_type");
var _match_filters_to_index_pattern = require("./match_filters_to_index_pattern");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/query_bar/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isDataView = obj => obj != null && typeof obj === 'object' && Object.hasOwn(obj, 'getName');
exports.isDataView = isDataView;
const CustomStylesWrapper = ({
  children
}) => {
  const wrapperClassName = 'ruleEditQueryBarWrapper';
  const customCss = (0, _react2.css)`
    .${wrapperClassName} .kbnQueryBar__filterButtonGroup {
      align-self: start;
    }

    .${wrapperClassName} .kbnQueryBar__wrap {
      height: auto !important;
    }
  `;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_react2.Global, {
    styles: customCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: wrapperClassName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, children));
};
const QueryBar = exports.QueryBar = /*#__PURE__*/(0, _react.memo)(({
  dateRangeFrom,
  dateRangeTo,
  hideSavedQuery = false,
  indexPattern,
  isLoading = false,
  isRefreshPaused,
  filterQuery,
  filterManager,
  filters,
  onChangedQuery,
  onSubmitQuery,
  refreshInterval,
  savedQuery,
  onSavedQuery,
  dataTestSubj,
  displayStyle,
  isDisabled,
  bubbleSubmitEvent,
  preventCacheClearOnUnmount = false
}) => {
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const [dataView, setDataView] = (0, _react.useState)();
  const onQuerySubmit = (0, _react.useCallback)(payload => {
    if (payload.query != null && !(0, _fastDeepEqual.default)(payload.query, filterQuery)) {
      const payloadQuery = (0, _convert_to_query_type.convertToQueryType)(payload.query);
      onSubmitQuery(payloadQuery);
    }
  }, [filterQuery, onSubmitQuery]);
  const onQueryChange = (0, _react.useCallback)(payload => {
    if (onChangedQuery && payload.query != null && !(0, _fastDeepEqual.default)(payload.query, filterQuery)) {
      const payloadQuery = (0, _convert_to_query_type.convertToQueryType)(payload.query);
      onChangedQuery(payloadQuery);
    }
  }, [filterQuery, onChangedQuery]);
  const onSavedQueryUpdated = (0, _react.useCallback)(savedQueryUpdated => {
    const {
      query: newQuery,
      filters: newFilters,
      timefilter
    } = savedQueryUpdated.attributes;
    onSubmitQuery(newQuery, timefilter);
    filterManager.setFilters(newFilters || []);
    onSavedQuery(savedQueryUpdated);
  }, [filterManager, onSubmitQuery, onSavedQuery]);
  const onClearSavedQuery = (0, _react.useCallback)(() => {
    if (savedQuery != null) {
      onSubmitQuery({
        query: '',
        language: savedQuery.attributes.query.language
      });
      filterManager.setFilters([]);
      onSavedQuery(undefined);
    }
  }, [filterManager, onSubmitQuery, onSavedQuery, savedQuery]);
  const onFiltersUpdated = (0, _react.useCallback)(newFilters => {
    filterManager.setFilters(newFilters);
  }, [filterManager]);
  const isEsql = (filterQuery === null || filterQuery === void 0 ? void 0 : filterQuery.language) === 'esql';
  const query = (0, _react.useMemo)(() => {
    if (isEsql && typeof filterQuery.query === 'string') {
      return {
        esql: filterQuery.query
      };
    }
    return filterQuery;
  }, [filterQuery, isEsql]);
  (0, _react.useEffect)(() => {
    let dv;
    if (isDataView(indexPattern)) {
      setDataView(indexPattern);
    } else if (!isEsql && !(0, _lodash.isEmpty)(indexPattern.title)) {
      const createDataView = async () => {
        dv = await data.dataViews.create({
          id: indexPattern.title,
          title: indexPattern.title
        });
        setDataView(dv);
      };
      createDataView();
    }
    return () => {
      var _dv;
      // Cache needs to be cleared in certain instances where ad-hoc dataviews are created, like rule creation
      if ((_dv = dv) !== null && _dv !== void 0 && _dv.id && !preventCacheClearOnUnmount) {
        var _dv2;
        data.dataViews.clearInstanceCache((_dv2 = dv) === null || _dv2 === void 0 ? void 0 : _dv2.id);
      }
    };
  }, [data.dataViews, indexPattern, isEsql, preventCacheClearOnUnmount]);
  const searchBarFilters = (0, _react.useMemo)(() => {
    if (!(dataView !== null && dataView !== void 0 && dataView.id) || isEsql) {
      return filters;
    }
    return (0, _match_filters_to_index_pattern.matchFiltersToIndexPattern)(dataView.id, filters);
  }, [filters, isEsql, dataView === null || dataView === void 0 ? void 0 : dataView.id]);
  const timeHistory = (0, _react.useMemo)(() => new _public.TimeHistory(new _public3.Storage(localStorage)), []);
  const arrDataView = (0, _react.useMemo)(() => dataView != null ? [dataView] : [], [dataView]);
  return /*#__PURE__*/_react.default.createElement(CustomStylesWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public2.SearchBar, {
    showSubmitButton: false,
    dateRangeFrom: dateRangeFrom,
    dateRangeTo: dateRangeTo,
    filters: searchBarFilters,
    indexPatterns: arrDataView,
    isLoading: isLoading,
    isRefreshPaused: isRefreshPaused,
    query: query,
    onClearSavedQuery: onClearSavedQuery,
    onFiltersUpdated: onFiltersUpdated,
    onQueryChange: onQueryChange,
    onQuerySubmit: onQuerySubmit,
    onSaved: onSavedQuery,
    onSavedQueryUpdated: onSavedQueryUpdated,
    refreshInterval: refreshInterval,
    showAutoRefreshOnly: false,
    showFilterBar: !hideSavedQuery,
    showDatePicker: false,
    showQueryInput: true,
    showSaveQuery: true,
    timeHistory: timeHistory,
    dataTestSubj: dataTestSubj,
    savedQuery: savedQuery,
    displayStyle: isEsql ? 'withBorders' : displayStyle,
    isDisabled: isDisabled,
    bubbleSubmitEvent: bubbleSubmitEvent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 9
    }
  }));
});
QueryBar.displayName = 'QueryBar';