"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoPrivilegesPage = exports.NoPrivileges = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _kibana = require("../../lib/kibana");
var _page_wrapper = require("../page_wrapper");
var _empty_page = require("../empty_page");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/no_privileges/no_privileges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SizedEuiFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  min-height: 460px;
  font-size: 1.1rem;
`;
const NoPrivilegesPage = exports.NoPrivilegesPage = /*#__PURE__*/_react.default.memo(({
  pageName,
  docLinkSelector
}) => /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 31,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 32,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(SizedEuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 33,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 34,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(NoPrivileges, {
  pageName: pageName,
  docLinkSelector: docLinkSelector,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 35,
    columnNumber: 13
  }
}))))));
NoPrivilegesPage.displayName = 'NoPrivilegePage';
const NoPrivileges = exports.NoPrivileges = /*#__PURE__*/_react.default.memo(({
  pageName,
  docLinkSelector
}) => {
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const emptyPageActions = (0, _react.useMemo)(() => ({
    feature: {
      icon: 'documents',
      label: i18n.GO_TO_DOCUMENTATION,
      url: docLinkSelector(docLinks.links),
      target: '_blank'
    }
  }), [docLinkSelector, docLinks.links]);
  const message = pageName ? i18n.NO_PRIVILEGES_PER_PAGE_MESSAGE(pageName) : i18n.NO_PRIVILEGES_DEFAULT_MESSAGE;
  return /*#__PURE__*/_react.default.createElement(_empty_page.EmptyPage, {
    actions: emptyPageActions,
    message: message,
    "data-test-subj": "noPrivilegesPage",
    title: i18n.NO_PERMISSIONS_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  });
});
NoPrivileges.displayName = 'NoPrivileges';