"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlNetworkConditionalContainer = void 0;
var _queryString = require("query-string");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/kibana-utils-plugin/public");
var _add_entities_to_kql = require("./add_entities_to_kql");
var _replace_kql_parts = require("./replace_kql_parts");
var _entity_helpers = require("./entity_helpers");
var _constants = require("../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/ml/conditional_links/ml_network_conditional_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MlNetworkConditionalContainer = exports.MlNetworkConditionalContainer = /*#__PURE__*/_react.default.memo(() => {
  const {
    path
  } = (0, _reactRouterDom.useRouteMatch)();
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    strict: true,
    exact: true,
    path: path,
    render: ({
      location
    }) => {
      const queryStringDecoded = (0, _queryString.parse)(location.search.substring(1), {
        sort: false
      });
      if (queryStringDecoded.query != null) {
        queryStringDecoded.query = (0, _replace_kql_parts.replaceKQLParts)(queryStringDecoded.query);
      }
      const reEncoded = (0, _queryString.stringify)(_public.url.encodeQuery(queryStringDecoded), {
        sort: false,
        encode: false
      });
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: `${_constants.NETWORK_PATH}?${reEncoded}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 18
        }
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${path}/ip/:ip`,
    render: ({
      location,
      match: {
        params: {
          ip
        }
      }
    }) => {
      const queryStringDecoded = (0, _queryString.parse)(location.search.substring(1), {
        sort: false
      });
      if (queryStringDecoded.query != null) {
        queryStringDecoded.query = (0, _replace_kql_parts.replaceKQLParts)(queryStringDecoded.query);
      }
      if ((0, _entity_helpers.emptyEntity)(ip)) {
        const reEncoded = (0, _queryString.stringify)(_public.url.encodeQuery(queryStringDecoded), {
          sort: false,
          encode: false
        });
        return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
          to: `${_constants.NETWORK_PATH}/flows?${reEncoded}`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 72,
            columnNumber: 20
          }
        });
      } else if ((0, _entity_helpers.multipleEntities)(ip)) {
        const ips = (0, _entity_helpers.getMultipleEntities)(ip);
        queryStringDecoded.query = (0, _add_entities_to_kql.addEntitiesToKql)(['source.ip', 'destination.ip'], ips, queryStringDecoded.query || '');
        const reEncoded = (0, _queryString.stringify)(_public.url.encodeQuery(queryStringDecoded), {
          sort: false,
          encode: false
        });
        return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
          to: `${_constants.NETWORK_PATH}/flows?${reEncoded}`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 84,
            columnNumber: 20
          }
        });
      } else {
        const reEncoded = (0, _queryString.stringify)(_public.url.encodeQuery(queryStringDecoded), {
          sort: false,
          encode: false
        });
        return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
          to: `${_constants.NETWORK_PATH}/ip/${ip}?${reEncoded}`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 90,
            columnNumber: 20
          }
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_PATH}/ml-network/`,
    render: ({
      location: {
        search = ''
      }
    }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      from: `${_constants.NETWORK_PATH}/ml-network/`,
      to: {
        pathname: `${_constants.NETWORK_PATH}/ml-network`,
        search
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }));
});
MlNetworkConditionalContainer.displayName = 'MlNetworkConditionalContainer';