"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDefaultWhenEmptyString = exports.getSettingKey = void 0;
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Returns a settings key, typically used with local storage */
const getSettingKey = ({
  category,
  page,
  setting
}) => `${page}.${category}.${setting}`;
exports.getSettingKey = getSettingKey;
const isDefaultWhenEmptyString = value => typeof value !== 'string' || (0, _fp.isEmpty)(value.trim());
exports.isDefaultWhenEmptyString = isDefaultWhenEmptyString;