"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkIcon = exports.Link = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/link_icon/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Link = exports.Link = (0, _styledComponents.default)(({
  iconSide,
  children,
  ...rest
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, rest, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 25,
    columnNumber: 3
  }
}), children))`
  ${({
  iconSide,
  theme
}) => (0, _styledComponents.css)`
    align-items: center;
    display: inline-flex;
    vertical-align: top;
    white-space: nowrap;

    ${iconSide === 'left' && (0, _styledComponents.css)`
      .euiIcon {
        margin-right: ${theme.eui.euiSizeXS};
      }
    `}

    ${iconSide === 'right' && (0, _styledComponents.css)`
      flex-direction: row-reverse;

      .euiIcon {
        margin-left: ${theme.eui.euiSizeXS};
      }
    `}
  `}
`;
Link.displayName = 'Link';
const LinkIcon = exports.LinkIcon = /*#__PURE__*/_react.default.memo(({
  ariaLabel,
  children,
  color,
  dataTestSubj,
  disabled,
  href,
  iconSide = 'left',
  iconSize = 's',
  iconType,
  onClick
}) => {
  const getChildrenString = (0, _react.useCallback)(theChild => {
    if (typeof theChild === 'object' && theChild != null && 'props' in theChild && theChild.props && theChild.props.children) {
      return getChildrenString(theChild.props.children);
    }
    return theChild != null && Object.keys(theChild).length > 0 ? theChild : '';
  }, []);
  const aria = (0, _react.useMemo)(() => {
    if (ariaLabel) {
      return ariaLabel;
    }
    return getChildrenString(children);
  }, [ariaLabel, children, getChildrenString]);
  return /*#__PURE__*/_react.default.createElement(Link, {
    className: "siemLinkIcon",
    color: color,
    "data-test-subj": dataTestSubj,
    disabled: disabled,
    href: href,
    iconSide: iconSide,
    onClick: onClick,
    "aria-label": aria,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: iconSize,
    type: iconType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "siemLinkIcon__label",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, children));
});
LinkIcon.displayName = 'LinkIcon';