"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.networkTopCountriesSchema = void 0;
var _zod = require("@kbn/zod");
var _factory_query_type = require("../model/factory_query_type");
var _filter_query = require("../model/filter_query");
var _request_paginated_options = require("../model/request_paginated_options");
var _sort = require("../model/sort");
var _timerange = require("../model/timerange");
var _flow_target = require("./model/flow_target");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const networkTopCountriesSchema = exports.networkTopCountriesSchema = _request_paginated_options.requestOptionsPaginatedSchema.extend({
  ip: _zod.z.string().ip().optional(),
  flowTarget: _flow_target.flowTarget,
  sort: _sort.sort,
  filterQuery: _filter_query.filterQuery,
  timerange: _timerange.timerange,
  factoryQueryType: _zod.z.literal(_factory_query_type.NetworkQueries.topCountries)
});